<form action="<?php echo e(route('/postEditSponsor')); ?>/<?php echo e($i->id); ?>" method="post" id="editSponsorForm">
    <div class="form-group col-sm-12">
        <label for="">Sponsor Name *</label>
        <input type="text" name="sponsorName" value="<?php echo e($i->sponsorName); ?>" required class="form-control">
    </div>
    <div class="form-group col-sm-12">
        <label for="">Sponsor Website Link *</label>
        <input type="url" name="sponsorUrl" required value="<?php echo e($i->sponsorUrl); ?>" class="form-control">
    </div>
    <div class="form-group col-sm-12">
        <select name="publishStatus" required class="form-control" id="">
            <option value="0" <?php if($i->publishStatus=='0'): ?> selected <?php endif; ?>>Publish</option>
            <option value="1" <?php if($i->publishStatus=='1'): ?> selected <?php endif; ?>>Draft</option>
        </select>
    </div>
    <?php echo e(csrf_field()); ?>

    <div class="form-group col-sm-4">
        <button class="btn btn-md btn-success" id="sponsorEditBtn"><i class="fa fa-arrow-circle-o-right"></i> SAVE SPONSOR</button>
    </div>
</form>

<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ready(function () {
        $('#editSponsorForm').submit(function (e) {
            e.preventDefault();
            $('#sponsorEditBtn').prop('disabled', true).html('SAVING SPONSOR');
            var url = $(this).attr('action');
            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: url,
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#sponsorEditBtn').prop('disabled', false).html('SAVE SPONSOR');
                        swal(data.encounters, '', 'warning');
                    }
                    else{
                        swal('UPDATED SUCCESSFUL', '', 'success');
                        $('#editSponsor').modal('hide');
                    }
                }
            });

        });
    });
</script>