<?php $__env->startSection('title'); ?>
    BETLOADED | Load Leagues
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page'); ?>
    Leagues
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col" style="min-height: 323px;;">
        <br>
        <?php
        $date = new dateTime();
        $d = $date->format('j F, Y');
        ?>

        <form action="#" method="POST" id="newleague">
            <div class="row">
                <div class="form-group col-sm-6">
                    <input class="form-control" name="league" id="league" placeholder="LEAGUE NAME" required>
                </div>
                <div class="form-group col-sm-4">
                    <input class="form-control" name="short" id="short" placeholder="LEAGUE CODE e.g EPL" required>
                </div>

                <?php echo csrf_field(); ?>


                <div class="form-group col-sm-2">
                    <button class="btn btn-md btn-success" name="submit" id="leaguebtn">ADD</button>
                </div>
                <div class="form-group col-xs-6" id="leaguestatus"></div>

            </div>
        </form>
        <hr>
        <div class="row">
            <div class="col-xs-12" id="existingleagues">
                <table class="table table-striped" id="datatable">
                    <thead>
                    <tr>
                        <th>S/N</th>
                        <th>LEAGUE</th>
                        <th>SHORT CODE</th>
                        <th>DELETE</th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($allleagues->all() as $league): ?>
                    <tr id="<?php echo e($league->id); ?>">
                        <td><?php echo e($league->id); ?></td>
                        <td><?php echo e($league->league); ?></td>
                        <td><?php echo e($league->code); ?></td>
                        <td><a href="<?php echo e($league->id); ?>" class="trashleague">Delete</a> </td>
                    </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>