<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <link rel="SHORTCUT ICON" href="<?php echo e(asset('images/eicon.png')); ?>">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link href="https://fonts.googleapis.com/css?family=Changa" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">
    <!-- Bootstrap -->
    <link href="<?php echo e(asset('vendors/bootstrap/dist/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="<?php echo e(asset('vendors/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">
    <!-- iCheck -->
    <link href="<?php echo e(asset('vendors/iCheck/skins/flat/green.css')); ?>" rel="stylesheet">
    <!-- bootstrap-progressbar -->
    <link href="<?php echo e(asset('vendors/bootstrap-progressbar/css/bootstrap-progressbar-3.3.4.min.css')); ?>" rel="stylesheet">
    
    <?php /*DATA TABLES*/ ?>
    <link href="<?php echo e(asset('vendors/datatables.net-bs/css/dataTables.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css')); ?>" rel="stylesheet">
    
    <!-- Custom Theme Style -->
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet">
</head>

<body class="nav-md" style="font-family: 'Changa', sans-serif;">
<div class="container body">
    <div class="main_container">
        <div class="col-md-3 left_col">
            <div class="left_col scroll-view">
                <div class="navbar nav_title" style="border: 0; margin-bottom: 20px;">
                    <br>
                    <a href="<?php echo e(url('/')); ?>" class="site_title"><span><img src="<?php echo e(asset('images/eventry.png')); ?>"></span></a>
                </div>
                <!-- menu profile quick info -->
                <div class="profile">
                    <div class="profile_pic">
                        <img src="images/img.jpg" alt="..." class="img-circle profile_img">
                    </div>
                    <div class="profile_info" style="margin-bottom: 30px;">
                        <span>Welcome,</span>
                        <h2>
                            <?php
                                if(Auth::check()){
                                    $admin = Auth::user();
                                }
                            ?>
                            <?php echo e($admin->name); ?></h2>
                    </div>
                </div>
                <!-- /menu profile quick info -->

                <br />

                <!-- sidebar menu -->
                <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
                    <div class="menu_section">
                        <ul class="nav side-menu">
                            <li><a href="<?php echo e(url('/home')); ?>"><i class="fa fa-dashboard"></i> Dashboard</a>
                            </li>
                            <li><a><i class="fa fa-calendar"></i> Events <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/allevents')); ?>">All Events <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($allevents); ?></span></a>
                                    </li>
                                    <li><a href="<?php echo e(url('/todayfree')); ?>">Today Free Events <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($todayfree); ?></span></a>
                                    </li>
                                    <li><a href="<?php echo e(url('/todaypaid')); ?>">Today Paid Events <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($todaypaid); ?></span></a>
                                    </li>
                                    <li><a href="<?php echo e(url('/flagged')); ?>">Flagged Events <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($flagged); ?></span></a>
                                    </li>
                                    <li><a href="<?php echo e(url('/disabled')); ?>">Disabled Events <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($disabled); ?></span></a>
                                    </li>
                                </ul>
                            </li>
                            <li><a><i class="fa fa-users"></i> General Users <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/generalusers')); ?>">All Users</a>
                                    </li>
                                    <li><a href="#">Marked Users</a>
                                    </li>
                                </ul>
                            </li>
                            <li><a><i class="fa fa-user-secret"></i> Subscribers <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/onetimeaccts')); ?>">One-Time Accounts <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($onetime); ?></span></a>
                                    </li>
                                    <li><a href="<?php echo e(url('/perthreeacct')); ?>">Per-Three Accounts <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($perthree); ?></span></a>
                                    </li>
                                    <li><a href="<?php echo e(url('/annual')); ?>">Yearly Accounts <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($annual); ?></span></a>
                                    </li>
                                    <li><a href="<?php echo e(url('/dormant')); ?>">Dormant Accounts <span class="badge orange" style="font-family: 'Lato', sans-serif; "><?php echo e($dormant); ?></span></a>
                                    </li>
                                </ul>
                            </li>
                            <li><a><i class="fa fa-ticket"></i> Tokens <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/')); ?>">Generate Tokens</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/')); ?>">All Tokens</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/')); ?>">Valid Tokens</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/')); ?>">Used Tokens</a>
                                    </li>
                                </ul>
                            </li>
                            <li><a href="<?php echo e(url('/')); ?>"><i class="fa fa-paypal"></i> Configure Payment </a>

                        </ul>
                    </div>

                </div>
                <!-- /sidebar menu -->

                <!-- /menu footer buttons -->
                <div class="sidebar-footer hidden-small">

                </div>
                <!-- /menu footer buttons -->
            </div>
        </div>

        <!-- top navigation -->
        <div class="top_nav">

            <div class="nav_menu">
                <nav class="" role="navigation">
                    <div class="nav toggle">
                        <a id="menu_toggle"><i class="fa fa-bars"></i></a>
                    </div>

                    <ul class="nav navbar-nav navbar-right">
                        <li class="">
                            <a href="javascript:;" class="user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                <img src="images/img.jpg" alt=""><?php echo e($admin->username); ?>

                                <span class=" fa fa-angle-down"></span>
                            </a>
                            <ul class="dropdown-menu dropdown-usermenu pull-right">
                                <li><a href="#" data-target="#admin" data-toggle="modal">  Profile</a>
                                </li>
                                <li>
                                    <?php if($admin->category=='Super'): ?>
                                    <a href="#" data-target="#newadmin" data-toggle="modal">
                                        <span>Create New Admin</span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <li><a href="<?php echo e(url('/logout')); ?>"><i class="fa fa-sign-out pull-right"></i> Log Out</a>
                                </li>
                            </ul>
                        </li>

                    </ul>
                </nav>
            </div>

        </div>
        <!-- /top navigation -->


        <!-- page content -->
        <div class="right_col" role="main">

            <!-- top tiles -->
            <div class="row tile_count">
                <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-calendar"></i> All Events</span>
                    <div class="count"><?php echo e($allevents); ?></div>
                    <a href="<?php echo e(url('/allevents')); ?>">View/Manage</a>
                </div>
                <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-calendar-check-o"></i> Today's Free Events</span>
                    <div class="count red"><?php echo e($todayfree); ?></div>
                    <a href="<?php echo e(url('/todayfree')); ?>">View/Manage</a>
                </div>
                <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-calendar-check-o"></i> Today's Paid Events</span>
                    <div class="count red"><?php echo e($todaypaid); ?></div>
                    <a href="<?php echo e(url('/todaypaid')); ?>">View/Manage</a>
                </div>
                <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-users"></i> All Users</span>
                    <div class="count green"><?php echo e($allusers); ?></div>
                    <a href="">View/Manage</a>

                </div>
                <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-user-times"></i> Free Acounts</span>
                    <div class="count"><?php echo e($freeuser); ?></div>
                    <a href="">View/Manage</a>
                </div>
                <div class="col-md-2 col-sm-4 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-user-secret"></i> Subscribers</span>
                    <div class="count"><?php echo e($paiduser); ?></div>
                    <a href="">View/Manage</a>

                </div>
            </div>
            <!-- /top tiles -->
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="dashboard_graph" style="height: 400px; overflow: auto;">

                        <div class="row x_title">
                            <div class="col-md-6">
                                <h3>Dashboard Controls: <span class="green"><?php echo $__env->yieldContent('page'); ?></span></h3>
                            </div>

                        </div>

                        <?php echo $__env->yieldContent('content'); ?>

                        <div class="modal" id="eventdetail">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4>Event Details</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="ebody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="creator">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4>Event Creator</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="cbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="eventsetting">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Event Settings</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="sbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="usersetting">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Account Settings</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="abody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="eventdelete">
                            <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-trash"></span> Event Destroyer</h4>
                                    </div>
                                    <div class="modal-body">
                                        <center>
                                            <h4>Confirm Deletion</h4>
                                        </center>
                                        <form action="#" method="POST" id="eventdeleteform">
                                            <div class="form-group">
                                                <input type="text"  id="evid" name="eventid" class="form-control" value="">
                                            </div>

                                            <div class="form-group">
                                                <input type="password" id="delpass" name="password" class="form-control">
                                            </div>
                                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                            <div class="form-group">
                                                <div id="deletestatusbox"></div><br>
                                                <center><button class="btn btn-sm btn-success" type="submit" id="submitdelete">Delete</button></center>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="userdelete">
                            <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-trash"></span> Account Destroyer</h4>
                                    </div>
                                    <div class="modal-body">
                                        <center>
                                            <h4>Confirm Deletion</h4>
                                        </center>
                                        <form action="#" method="POST" id="userdeleteform">
                                            <div class="form-group">
                                                <input type="text"  id="useidd" name="userid" class="form-control" value="">
                                            </div>

                                            <div class="form-group">
                                                <input type="password" id="deluserpass" name="password" class="form-control">
                                            </div>
                                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                            <div class="form-group">
                                                <div id="userdeletestatus"></div><br>
                                                <center><button class="btn btn-sm btn-success" type="submit" id="submituserdelete">Delete</button></center>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <?php /*ADMIN SETTINGS*/ ?>
                        <div class="modal" id="admin">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Admin Settings</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                        <div class="col-md-10 col-md-offset-1">

                                            <form action="#" method="POST" id="adminsetting">
                                                <div class="form-group">
                                                    <input type="text" name="adminname" class="form-control" value="<?php echo e($admin->name); ?>" placeholder="Admin Name" required>
                                                </div>

                                                <div class="form-group">
                                                    <input type="text" name="adminusername" class="form-control" value="<?php echo e($admin->username); ?>" placeholder="Admin Username" required>
                                                </div>

                                                <div class="form-group">
                                                    <input type="email" name="adminemail" class="form-control" value="<?php echo e($admin->email); ?>" placeholder="Login Email" required>
                                                </div>

                                                <div class="form-group">
                                                    <input type="password" name="adminopkey" class="form-control" value="<?php echo e($admin->operation_key); ?>" placeholder="Operation Key" required>
                                                </div>
                                                <h4>Change Password</h4>
                               <div class="divider"></div>
                                                <div class="form-group">
                                                    <input type="password" name="adminoldpassword" class="form-control"  placeholder="Existing Password">
                                                </div>

                                                <div class="form-group">
                                                    <input type="password" name="adminnewpassword" class="form-control"  placeholder="Define New Password">
                                                </div>

                                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                <div class="form-group">
                                                    <div id="adminstatus"></div><br>
                                                    <button class="btn btn-md btn-success" type="submit" id="adminsettingbtn">Save Changes</button>
                                                </div>

                                            </form>
                                        </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <?php /*NEW ADMIN REGISTRATION*/ ?>
                        <div class="modal" id="newadmin">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Admin Registration</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-10 col-md-offset-1">

                                                <form action="#" method="POST" id="newadminform">
                                                    <div class="form-group">
                                                        <input type="text" name="adminname" class="form-control"  placeholder="Admin Name" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <input type="text" name="adminusername" class="form-control"  placeholder="Admin Username" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <input type="email" name="adminemail" class="form-control" placeholder="Login Email" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <select name="category" class="form-control" required>
                                                            <option value="">Admin Role</option>
                                                            <option value="Intermediate">Intermediate</option>
                                                            <option value="General">General</option>
                                                        </select>
                                                    </div>

                                                    <div class="form-group">
                                                        <input type="password" name="adminopkey" class="form-control" placeholder="Operation Key" required>
                                                    </div>
                                                    <h4>Define Password</h4>
                                                    <div class="divider"></div>
                                                    <div class="form-group">
                                                        <input type="password" name="password" class="form-control"  placeholder="Password">
                                                    </div>

                                                    <div class="form-group">
                                                        <input type="password" name="repassword" class="form-control"  placeholder="Confirm Password">
                                                    </div>

                                                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                    <div class="form-group">
                                                        <div id="newadminstatus"></div><br>
                                                        <button class="btn btn-md btn-success" type="submit" id="newadminbtn">Save Changes</button>
                                                    </div>

                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="clearfix"></div>
                    </div>

                </div>

            </div>

        </div>
        <!-- /page content -->

        <!-- footer content -->
        <footer>
            <div class="pull-right">
                &copy; eventry.ng (2016) | All rights reserved
            </div>
            <div class="clearfix"></div>
        </footer>
        <!-- /footer content -->
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo e(asset('vendors/jquery/dist/jquery.min.js')); ?>"></script>
<!-- Bootstrap -->
<script src="<?php echo e(asset('vendors/bootstrap/dist/js/bootstrap.min.js')); ?>"></script>
<!-- FastClick -->
<script src="<?php echo e(asset('vendors/fastclick/lib/fastclick.js')); ?>"></script>
<!-- NProgress -->
<script src="<?php echo e(asset('vendors/nprogress/nprogress.js')); ?>"></script>
<!-- gauge.js -->
<script src="<?php echo e(asset('vendors/bernii/gauge.js/dist/gauge.min.js')); ?>"></script>
<!-- bootstrap-progressbar -->
<script src="<?php echo e(asset('vendors/bootstrap-progressbar/bootstrap-progressbar.min.js')); ?>"></script>

<?php /*Datatables */ ?>
<script src="<?php echo e(asset('vendors/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-bs/js/dataTables.bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js')); ?>"></script>
<?php /*<script src="<?php echo e(asset('vendors/datatables.net-scroller/js/datatables.scroller.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/jszip/dist/jszip.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/pdfmake/build/pdfmake.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/pdfmake/build/vfs_fonts.js')); ?>"></script>*/ ?>

<!-- Custom Theme Scripts -->
<script src="<?php echo e(asset('js/custom.js')); ?>"></script>
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ready(function () {
        $('#datatable-responsive').DataTable({
            "bPaginate": false
        });

        $('.eventview').click(function(){
            var eventcode = $(this).attr('href');
//            var dataString = "eid="+eventcode;
            $('#ebody').html('Fetching...');
            $.ajax({
                type: "GET",
                url: "ajaxallevents/"+eventcode,
//              data: dataString,
                success: function (data) {
                    console.log(data);
                $('#ebody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.creatorview').click(function(){
            var creator = $(this).attr('href');
            $('#cbody').html('Loading...');
            $.ajax({
                type: "GET",
                url: "ajaxcreator/"+creator,
                success: function (data) {
                    $('#cbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.eventsetting').click(function(){
            var eventid = $(this).attr('href');
            $('#sbody').html('Fetching Controls...');
            $.ajax({
                type: "GET",
                url: "ajaxsetting/"+eventid,
                success: function (data) {
                    $('#sbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.usersettinghref').click(function(){
            var userid = $(this).attr('href');
            $('#abody').html('Fetching...');
            $.ajax({
                type: "GET",
                url: "ajaxusersetting/"+userid,
                success: function (data) {
                    $('#abody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('#adminsetting').submit(function (e) {
            e.preventDefault();
            $('#adminstatus').html('Updating... Please wait');
            $('#adminsettingbtn').prop('disabled', true);

            var dataString = $(this).serialize();
            console.log(dataString);
            $.ajax({
                type: "POST",
                url: "ajaxadminsetting",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#adminsettingbtn').prop('disabled', false);
                        $('#adminstatus').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $('#adminstatus').html(data.encounters);
                        alert(data.encounters);
                        $('#admin').modal('hide');
                    }
                }
            });

        });

        $('#newadminform').submit(function (e) {
            e.preventDefault();
            $('#newadminstatus').html('Registering... Please wait');
            $('#newadminbtn').prop('disabled', true);

            var dataString = $(this).serialize();
            console.log(dataString);
            $.ajax({
                type: "POST",
                url: "ajaxnewadmin",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#newadminbtn').prop('disabled', false);
                        $('#newadminstatus').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $('#newadminstatus').html(data.encounters);
                        alert(data.encounters);
                        $('#newadmin').modal('hide');
                    }
                }
            });

        });


        $('.flag').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#f'+id).css('color', 'red').html('Flagged');
            $.ajax({
                type: "GET",
                url: "ajaxflag/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.unflag').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#f'+id).css('color', 'black').html('Flag');
            $.ajax({
                type: "GET",
                url: "ajaxunflag/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.hided').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'red').html('Hidden');
            $.ajax({
                type: "GET",
                url: "ajaxhide/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.unhide').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'black').html('Hide');
            $.ajax({
                type: "GET",
                url: "ajaxunhide/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.eventdelete').click(function(){
            var eventid = $(this).attr('href');
            $('#evid').val(eventid);
        });

        $('.userdeletehref').click(function(){
            var userid = $(this).attr('href');
            $('#useidd').val(userid);
        });

        $('#eventdeleteform').submit(function (e) {
            e.preventDefault();
            $('#deletestatusbox').html('Deleting... Please wait');
            $('#submitdelete').prop('disabled', true);

            var dataString = $(this).serialize();
//            console.log(dataString);
            $.ajax({
                type: "POST",
                url: "ajaxeventdelete",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#submitdelete').prop('disabled', false);
                        $('#deletestatusbox').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        alert(data.encounters);
                        $('#eventdelete').modal('hide');
                    }
                }
            });

        });

        $('#userdeleteform').submit(function (e) {
            e.preventDefault();
            $('#userdeletestatus').html('Deleting... Please wait');
            $('#submituserdelete').prop('disabled', true);

            var dataString = $(this).serialize();
//            console.log(dataString);
            $.ajax({
                type: "POST",
                url: "ajaxuserdelete",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#submituserdelete').prop('disabled', false);
                        $('#userdeletestatus').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        alert(data.encounters);
                        $('#userdelete').modal('hide');
                    }
                }
            });

        });

        setTimeout(function() {
            $('#stat').modal('show'); //$del is the modal id
        }, 3000); // milliseconds

        setTimeout(function() {
            $('#stat').modal('hide');
        }, 12000); // milliseconds
    });
</script>
</body>
</html>