<div class="row">
    <div class="col-md-8">
    <h4><span class="red">TOKEN TYPE: </span><?php echo e($user->tokentype); ?></h4><br>
    </div>
    <br>
        <form action="#" method="POST" id="usersettingform">
            <div class="col-md-6">
                <div class="form-group">
                    <input name="userid" type="hidden" required value="<?php echo e($user->id); ?>">

                    <label for="tokentype">Token Type</label>
                    <select id="tokentype" class="form-control" name="tokentype">
                        <option value="<?php echo e($user->tokentype); ?>"><?php echo e($user->tokentype); ?></option>
                        <option value="PER-EVENT">PER-EVENT</option>
                        <option value="PER-THREE">PER-THREE</option>
                        <option value="ANNUAL">ANNUAL</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="duedate">Next Due Date (<?php echo e($user->dateregistered); ?>)</label>
                    <input id="duedate" class="form-control" name="duedate" type="text" required value="<?php echo e($user->nextduedate); ?>">
                </div>

                <div class="form-group">
                    <label for="events">Total Events</label>
                    <input id="events" class="form-control" name="totalevents" type="number" required value="<?php echo e($user->totalevents); ?>">
                </div>
            </div>

            <div class="col-md-6">

                <div class="form-group">
                    <label for="acctstatus">Account Status</label>
                    <input id="acctstatus" class="form-control" name="acctstatus" type="number" required value="<?php echo e($user->accountstatus); ?>">
                </div>

                <div class="form-group">
                    <label for="status">Status</label>
                    <input id="status" class="form-control" name="status" type="number" required value="<?php echo e($user->status); ?>">
                </div>

                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                <div class="form-group">
                    <div id="settingstatus"></div><br>
                    <button class="btn btn-md btn-success" type="submit" id="submitsetting">Save Changes</button>
                </div>
            </div>
        </form>
</div>

<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ready(function () {
        $('#usersettingform').submit(function (e) {
            e.preventDefault();
            $('#settingstatus').html('Updating... Please wait');
            $('#submitsetting').prop('disabled', true);

            var dataString = $(this).serialize();
            console.log(dataString);
            $.ajax({
                type: "POST",
                url: "ajaxusersetting",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#submitsetting').prop('disabled', false);
                        $('#settingstatus').html(data.encounters);
                        console.log(data);
                    }
                    else{
//                        $('#settingstatus').html(data.encounters);
                        alert(data.encounters);
                        $('#usersetting').modal('hide');
                    }
                }
            });

        });
    });
</script>