<?php $__env->startSection('title'); ?>
    eventry.ng | All Events
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page'); ?>
    All Events
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col" style="min-height: 323px;;">
        <br><br>
        <?php
        $date = new dateTime();
        $d = $date->format('j F, Y');
        ?>
        <table id="datatable-responsive" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
            <thead>
            <tr>
                <th>REL</th>
                <th>Event Code</th>
                <th>Edit Code</th>
                <th>Creator</th>
                <th>Category</th>
                <th>Type</th>
                <th>Start Date</th>
                <th>State</th>
                <th>Details</th>
                <th>Controls</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach($events->all() as $event): ?>
                <?php

                $creator = App\User::find($event->creator);
                ?>
            <tr>
                <td class="red"><?php echo e($event->accounttype); ?></td>
                <td><?php echo e($event->eventcode); ?></td>
                <td><?php echo e($event->editcode); ?></td>
                <td><a class="creatorview" href="<?php echo e($creator['id']); ?>" data-target="#creator" data-toggle="modal"><span style="color: brown;"><?php echo e($creator['user_name']); ?></span></a></td>
                <td><?php echo e($event->eventcategory); ?></td>
                <td><?php echo e($event->eventtype); ?></td>
                <?php if($event->eventstartdate==$d): ?>
                    <td><span class="red">TODAY</span></td>
                <?php else: ?>
                <td><?php echo e($event->eventstartdate); ?></td>
                <?php endif; ?>
                <td><?php echo e($event->state); ?></td>
                <td><a class="eventview" href="<?php echo e($event->eventcode); ?>" data-target="#eventdetail" data-toggle="modal"><span style="color: green;">VIEW</span></a></td>
                <td>
                    <div class="btn-group">
                        <button type="button" class="btn btn-default btn-xs dropdown-toggle" data-toggle="dropdown">
                            Actions
                            <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu pull-right" role="menu" style="background: whitesmoke; -webkit-box-shadow: inset 0px 0px 10px grey;-moz-box-shadow: inset 0px 0px 10px grey;box-shadow: inset 0px 0px 10px grey;">
                            <li style="cursor: pointer;"><a class="eventsetting" href="<?php echo e($event->eventcode); ?>" data-target="#eventsetting" data-toggle="modal">Settings</a>
                            <?php if($event->flagged=='0'): ?>
                            <li style="cursor: pointer;"><a class="flag" href="<?php echo e($event->id); ?>" id="f<?php echo e($event->id); ?>">Flag</a>
                            <?php else: ?>
                                <li style="cursor: pointer;"><a class="unflag" href="<?php echo e($event->id); ?>" id="f<?php echo e($event->id); ?>"><span style="color: red;">Unflag</span></a>
                            <?php endif; ?>

                            <?php if($event->status=='0'): ?>
                                <li style="cursor: pointer;"><a class="hided" href="<?php echo e($event->id); ?>" id="h<?php echo e($event->id); ?>">Hide</a>
                            <?php else: ?>
                                <li style="cursor: pointer;"><a class="unhide" href="<?php echo e($event->id); ?>" id="h<?php echo e($event->id); ?>"><span style="color: red;">Unhide</span></a>
                            <?php endif; ?>
                            <li style="cursor: pointer;"><a class="eventdelete" href="<?php echo e($event->eventcode); ?>" data-target="#eventdelete" data-toggle="modal">Delete</a>
                            </li>
                        </ul>
                    </div>
                </td>
            </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>