

<form action="#" id="planUpdater" method="post">
    <div class="form-group col-sm-12">
        <label for="">Sub. Name</label>
        <input type="hidden" name="id" value="<?php echo e($plan->id); ?>">
        <input type="text" class="form-control" name="plan" required placeholder="Subscription Name" value="<?php echo e($plan->planName); ?>">
    </div>

    <div class="form-group col-sm-12">
        <label for="">Access Time <small class="text-danger">Please, PAY ATTENTION!</small></label>
        <input type="text" class="form-control" name="accessTime" required placeholder="Subscription Access Time" value="<?php echo e($plan->accessTime); ?>">
    </div>

    <div class="form-group col-sm-12">
        <label for="">Naira Price <span class="text-danger"><strong>(N)</strong></span></label>
        <input type="number" name="nairaPrice" placeholder="Naira Price Value" required class="form-control" value="<?php echo e($plan->nairaPrice); ?>">
    </div>

    <div class="form-group col-sm-12">
        <label for="">Dollar Price <span class="text-danger"><strong>($)</strong></span></label>
        <input type="number" name="dollarPrice" placeholder="Dollar Price Value" required class="form-control" value="<?php echo e($plan->dollarPrice); ?>">
    </div>


    <div id="planstatus" class="col-xs-12"></div>

    <?php echo e(csrf_field()); ?>

    <div class="col-sm-12 form-group">
        <button class="btn btn-md btn-success" name="submit" id="planbtn">SAVE UPDATE</button>
    </div>
</form>

<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ready(function () {

        $('#planUpdater').submit(function (e) {
            e.preventDefault();
            $('#planstatus').html('Updating... Please wait');
            $('#planbtn').prop('disabled', true);

            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "planUpdater",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#planbtn').prop('disabled', false);
                        $('#planstatus').html(data.encounters);
                    }
                    else{
                        alert(data.encounters);
                        $('#planbtn').prop('disabled', false);
                        $('#planstatus').html('');
                        $('#planUpdater')[0].reset();
                        $('#planEditor').modal('hide');
                        location.reload();
                    }
                }
            });
        });

    });
</script>