<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="'Deji Busari & Folarin Farinto">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <link rel="SHORTCUT ICON" href="<?php echo e(asset('images/sglogo.png')); ?>">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link href="https://fonts.googleapis.com/css?family=Changa" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">
    <!-- Bootstrap -->
    <link href="<?php echo e(asset('vendors/bootstrap/dist/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="<?php echo e(asset('vendors/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">
    <!-- iCheck -->
    <link href="<?php echo e(asset('vendors/iCheck/skins/flat/green.css')); ?>" rel="stylesheet">
    <!-- bootstrap-progressbar -->
    <link href="<?php echo e(asset('vendors/bootstrap-progressbar/css/bootstrap-progressbar-3.3.4.min.css')); ?>" rel="stylesheet">
    
    <?php /*DATA TABLES*/ ?>
    <link href="<?php echo e(asset('vendors/datatables.net-bs/css/dataTables.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css')); ?>" rel="stylesheet">
    
    <!-- Custom Theme Style -->
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/bootstrap-fileupload.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/anytime.css')); ?>" rel="stylesheet">

    <script src="//cdn.tinymce.com/4/tinymce.min.js"></script>
</head>

<body class="nav-md" style="font-family: 'Changa', sans-serif;">
<?php
if(Auth::check()){
    $admin = Auth::user();
}
?>
<div class="container body">
    <div class="main_container">
        <div class="col-md-3 left_col">
            <div class="left_col scroll-view">
                <div class="navbar nav_title" style="border: 0; margin-bottom: 20px; height: 100px;">
                    <br>
                    <a href="<?php echo e(url('/home')); ?>" class="site_title" style="height: 100px;"><span><img src="<?php echo e(asset('images/stakelogo.png')); ?>" class="img-responsive" style="max-height: 100px;"></span></a>
                </div>
                <!-- menu profile quick info -->
                <div class="profile">
                    <div class="profile_pic">
                        <?php if($admin->dp!=NULL): ?><img src="<?php echo e(asset('images')); ?>/<?php echo e($admin->dp); ?>" alt="" class="img-circle profile_img" /><?php else: ?><img src="<?php echo e(asset('images/user.png')); ?>" alt="" class="img-circle profile_img" /><?php endif; ?>
                    </div>
                    <div class="profile_info" style="margin-bottom: 30px;">
                        <span>Welcome,</span>
                        <h2>

                            <?php echo e($admin->name); ?></h2>
                    </div>
                </div>
                <!-- /menu profile quick info -->

                <br />

                <!-- sidebar menu -->
                <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
                    <div class="menu_section">
                        <ul class="nav side-menu">
                            <li><a href="<?php echo e(url('/home')); ?>"><i class="fa fa-dashboard"></i> Dashboard</a>
                            </li>
                            <?php if($admin->category=='Super' || $admin->category=='Predictor'): ?>
                            <li><a><i class="fa fa-random"></i> PREDICTIONS <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/newgame')); ?>">Add New </a>
                                    </li>
                                    <li><a href="<?php echo e(url('/predictions')); ?>">Manage Existing </a>
                                    </li>
                                    <li><a href="<?php echo e(url('/testimonials')); ?>">Testimonials </a>
                                    </li>
                                </ul>
                            </li>
                            <?php endif; ?>
                            <?php if($admin->category=='Super' || $admin->category=='Blogger'): ?>
                            <li><a><i class="fa fa-share-alt"></i> BLOG <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/nblog')); ?>">Add News</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/blogs')); ?>">Managing News</a>
                                    </li>
                                </ul>
                            </li>
                            <?php endif; ?>
                            <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                            <li><a><i class="fa fa-users"></i> MEMBERSHIPS <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/allmembers')); ?>">View/Manage </a>
                                    </li>
                                    <li><a class="text-danger" style="color: chartreuse!important;;">SUBSCRIBED MEMBERS<span class="fa fa-chevron-down"></span></a>
                                        <ul class="nav child_menu">
                                            <li><a href="<?php echo e(route('/subscribed')); ?>" style="color: chartreuse!important;;">Currently Active</a>
                                            </li>
                                            <li><a href="<?php echo e(route('/expired')); ?>" style="color: red!important;;">Expired Users</a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li><a href="<?php echo e(url('/dmembers')); ?>">Disabled Members </a>
                                    </li>
                                    <li><a href="<?php echo e(url('/fmembers')); ?>">Flagged Members </a>
                                    </li>
                                </ul>
                            </li>
                            <li><a><i class="fa fa-ticket"></i> ADs <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/newads')); ?>">Post Ads</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/manageads')); ?>">Manage Ads</a>
                                    </li>
                                </ul>
                            </li>

                            <li><a><i class="fa fa-soccer-ball-o"></i> UPCOMING LEAGUE <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/slidenote')); ?>">Add New</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/notemanage')); ?>">Manage Existing</a>
                                    </li>
                                </ul>
                            </li>

                            <li><a><i class="fa fa-soccer-ball-o"></i> LEAGUES <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/loadleague')); ?>">Load Leagues</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/manageleague')); ?>">Manage Leagues</a>
                                    </li>
                                </ul>
                            </li>

                                <li><a><i class="fa fa-envelope"></i> EMAIL MANAGER <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/bulkmail')); ?>">To All Member</a></li>
                                    <li><a class="text-danger" style="color: chartreuse!important;;">TO SUBSCRIBED MEMBERS<span class="fa fa-chevron-down"></span></a>
                                        <ul class="nav child_menu">
                                            <li><a href="<?php echo e(route('/bulkActive')); ?>" style="color: chartreuse!important;;">Currently Active</a>
                                            </li>
                                            <li><a href="<?php echo e(route('/bulkExpired')); ?>" style="color: red!important;;">Expired Users</a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li><a href="<?php echo e(route('/individualMail')); ?>">To Individual(s)</a></li>
                                </ul>
                            </li>

                            <?php endif; ?>
                        </ul>
                    </div>

                </div>
                <!-- /sidebar menu -->

                <!-- /menu footer buttons -->
                <div class="sidebar-footer hidden-small">

                </div>
                <!-- /menu footer buttons -->
            </div>
        </div>

        <!-- top navigation -->
        <div class="top_nav">

            <div class="nav_menu">
                <nav class="" role="navigation">
                    <div class="nav toggle">
                        <a id="menu_toggle"><i class="fa fa-bars"></i></a>
                    </div>

                    <ul class="nav navbar-nav navbar-right">
                        <li class="">
                            <a href="javascript:;" class="user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                <?php if($admin->dp!=NULL): ?><img src="<?php echo e(asset('images')); ?>/<?php echo e($admin->dp); ?>" alt="" /><?php else: ?><img src="<?php echo e(asset('images/user.png')); ?>" alt="" /><?php endif; ?><?php echo e($admin->username); ?>

                                <span class=" fa fa-angle-down"></span>
                            </a>
                            <ul class="dropdown-menu dropdown-usermenu pull-right">
                                <li><a href="#" data-target="#admin" data-toggle="modal">  Profile</a>
                                </li>
                                <li>
                                    <?php if($admin->category=='Super'): ?>
                                    <a href="#" data-target="#newadmin" data-toggle="modal">
                                        <span>Create New Admin</span>
                                    </a>

                                    <a href="<?php echo e(url('/admins')); ?>">
                                        <span>Manage Admin</span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <li><a href="<?php echo e(url('/logout')); ?>"><i class="fa fa-sign-out pull-right"></i> Log Out</a>
                                </li>
                            </ul>
                        </li>

                    </ul>
                </nav>
            </div>

        </div>
        <!-- /top navigation -->


        <!-- page content -->
        <div class="right_col" role="main">

            <!-- top tiles -->
            <div class="row tile_count">
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-random"></i> Predictions</span>
                    <div class="count"><?php echo e($totalp); ?></div>
                    <?php if($admin->category=='Super' || $admin->category=='Predictor'): ?>
                    <a href="<?php echo e(url('/predictions')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-calendar-check-o"></i> Testimonials</span>
                    <div class="count red"><?php echo e($testimonial); ?></div>
                    <?php if($admin->category=='Super' || $admin->category=='Predictor'): ?>
                    <a href="<?php echo e(url('/testimonials')); ?>">View/Manage</a>
                    <?php endif; ?>
                </div>
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-users"></i> Members</span>
                    <div class="count"><?php echo e($users); ?></div>
                    <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                    <a href="<?php echo e(url('/allmembers')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-share-alt"></i> Blog Posts</span>
                    <div class="count red"><?php echo e($blogcount); ?></div>
                    <?php if($admin->category=='Super' || $admin->category=='Blogger'): ?>
                    <a href="<?php echo e(url('/blogs')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-ticket"></i> Ads Posts</span>
                    <div class="count"><?php echo e($adc); ?></div>
                    <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                    <a href="<?php echo e(url('/manageads')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>

                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-ticket"></i> Leagues Added</span>
                    <div class="count"><?php echo e($aleagues); ?></div>
                    <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                    <a href="<?php echo e(url('/manageleague')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>



            </div>
            <!-- /top tiles -->
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="dashboard_graph" style="height: 400px; overflow: auto;">

                        <div class="row x_title">
                            <div class="col-md-12">
                                <h3>Dashboard Controls: <span class="green"><?php echo $__env->yieldContent('page'); ?></span></h3>
                            </div>

                        </div>

                        <?php echo $__env->yieldContent('content'); ?>

                        <div class="modal" id="admincontrol">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4>Admin Control</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="adminbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="gamedetail">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4>Prediction Details</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="ebody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="blogdetail">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4>Blog Details</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="blogbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>


                        <div class="modal" id="updategame">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Update Prediction</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="ubody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="updateuserinfo">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Update User Information</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="userbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="userdetails">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-user"></span> USER INFORMATION</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="userinfobody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="upgradeuser">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-credit-card"></span> Upgrade User's Account</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="userupbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="modal" id="updateblog">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Update News</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="blbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="updateads">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Update Advert</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="adsbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="usersetting">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Account Settings</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="abody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="gamedelete">
                            <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-trash"></span> Delete Prediction</h4>
                                    </div>
                                    <div class="modal-body">
                                        <center>
                                            <h4>Confirm Deletion</h4>
                                        </center>
                                        <form action="#" method="POST" id="gamedeleteform">
                                            <div class="form-group">
                                                <input type="hidden"  id="gid" name="gameid" class="form-control" value="">
                                            </div>

                                            <div class="form-group">
                                                <input type="password" id="delpass" name="password" class="form-control" placeholder="PROVIDE OPERATION KEY HERE" required>
                                            </div>
                                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                            <div class="form-group">
                                                <div id="deletestatusbox"></div><br>
                                                <center><button class="btn btn-sm btn-success" type="submit" id="submitdelete">Delete</button></center>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="blogdelete">
                            <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-trash"></span> Delete Blog News</h4>
                                    </div>
                                    <div class="modal-body">
                                        <center>
                                            <h4>Confirm Deletion</h4>
                                        </center>
                                        <form action="#" method="POST" id="blogdeleteform">
                                            <div class="form-group">
                                                <input type="hidden"  id="bid" name="blogid" class="form-control" value="">
                                            </div>

                                            <div class="form-group">
                                                <input type="password" id="delpass" name="password" class="form-control" placeholder="PROVIDE OPERATION KEY HERE" required>
                                            </div>
                                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                            <div class="form-group">
                                                <div id="blogdeletestatusbox"></div><br>
                                                <center><button class="btn btn-sm btn-success" type="submit" id="blogsubmitdelete">Delete</button></center>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="adsdelete">
                            <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-trash"></span> Delete Advert</h4>
                                    </div>
                                    <div class="modal-body">
                                        <center>
                                            <h4>Confirm Deletion</h4>
                                        </center>
                                        <form action="#" method="POST" id="adsdeleteform">
                                            <div class="form-group">
                                                <input type="hidden"  id="adid" name="adid" class="form-control" value="">
                                            </div>

                                            <div class="form-group">
                                                <input type="password" id="delpass" name="password" class="form-control" placeholder="PROVIDE OPERATION KEY HERE" required>
                                            </div>
                                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                            <div class="form-group">
                                                <div id="adsdeletestatusbox"></div><br>
                                                <center><button class="btn btn-sm btn-success" type="submit" id="adssubmitdelete">Delete</button></center>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="userdelete">
                            <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-trash"></span> DELETE USER</h4>
                                    </div>
                                    <div class="modal-body">
                                        <center>
                                            <h4>Confirm Deletion</h4>
                                        </center>
                                        <form action="#" method="POST" id="userdeleteform">
                                            <div class="form-group">
                                                <input type="hidden"  id="usid" name="usid" class="form-control" value="">
                                            </div>

                                            <div class="form-group">
                                                <input type="password" id="delpass" name="password" class="form-control" placeholder="PROVIDE OPERATION KEY HERE" required>
                                            </div>
                                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                            <div class="form-group">
                                                <div id="userdeletestatusbox"></div><br>
                                                <center><button class="btn btn-sm btn-success" type="submit" id="usersubmitdelete">Delete</button></center>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="addresult">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Add Match Result</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="rbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="marktest">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-check-square-o"></span> Mark As Testimonial</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="tbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modal" id="addft">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-plus-square"></span> Add Other Recommendations</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div id="ftbody"></div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <?php /*ADMIN SETTINGS*/ ?>
                        <div class="modal" id="admin">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Admin Settings</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                        <div class="col-md-7">
                                            <form action="#" method="POST" id="adminsetting">
                                                <div class="form-group">
                                                    <input type="text" name="adminname" class="form-control" value="<?php echo e($admin->name); ?>" placeholder="Admin Name" required>
                                                </div>

                                                <div class="form-group">
                                                    <input type="text" name="adminusername" class="form-control" value="<?php echo e($admin->username); ?>" placeholder="Admin Username" required>
                                                </div>

                                                <div class="form-group">
                                                    <input type="email" name="adminemail" class="form-control" value="<?php echo e($admin->email); ?>" placeholder="Login Email" required>
                                                </div>

                                                <div class="form-group">
                                                    <input type="password" name="adminopkey" class="form-control" value="<?php echo e($admin->operation_key); ?>" placeholder="Operation Key" maxlength="5" required>
                                                </div>
                                                <h4>Change Password</h4>
                               <div class="divider"></div>
                                                <div class="form-group">
                                                    <input type="password" name="adminoldpassword" class="form-control"  placeholder="Existing Password">
                                                </div>

                                                <div class="form-group">
                                                    <input type="password" name="adminnewpassword" class="form-control"  placeholder="Define New Password">
                                                </div>

                                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                <div class="form-group">
                                                    <div id="adminstatus"></div><br>
                                                    <button class="btn btn-md btn-success" type="submit" id="adminsettingbtn">Save Changes</button>
                                                </div>

                                            </form>
                                        </div>
                                            <div class="col-md-5">
                                                <h5>CHANGE DEFAULT PICTURE</h5>
                                                <hr>
                                                <form action="<?php echo e(url('/dpupload')); ?>" method="POST" id="uploadfor" enctype="multipart/form-data">
                                                    <div class="col-sm-12">
                                                        <div class="input-field col-md-12">
                                                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                                                <div class="fileupload-new thumbnail" style="width: 160px; height: 150px;"><?php if($admin->dp!=NULL): ?><img src="<?php echo e(asset('images')); ?>/<?php echo e($admin->dp); ?>" alt="" /><?php else: ?><img src="<?php echo e(asset('images/user.png')); ?>" alt="" /><?php endif; ?></div>
                                                                <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 160px; max-height: 150px; line-height: 20px;"></div>
                                                                <div>
                <span class="btn btn-sm btn-file btn-default"><span class="fileupload-new">SELECT DP</span><span class="fileupload-exists">Change</span>
                <input type="file" name="file" required/></span>
                                                                    <a href="#" class="btn btn-sm btn-danger fileupload-exists" data-dismiss="fileupload">Remove</a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                    <div id="uploadstatus"></div><br>
                                                    <button class="btn btn-sm btn-success" id="uploadbtn">UPLOAD</button>
                                                </form>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <?php /*NEW ADMIN REGISTRATION*/ ?>
                        <div class="modal" id="newadmin">
                            <div class="modal-dialog modal-md">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                        <h4><span class="fa fa-cogs"></span> Admin Registration</h4>
                                    </div>
                                    <div class="modal-body">
                                        <div class="row">
                                            <div class="col-md-10 col-md-offset-1">

                                                <form action="#" method="POST" id="newadminform">
                                                    <div class="form-group">
                                                        <input type="text" name="adminname" class="form-control"  placeholder="Admin Name" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <input type="text" name="adminusername" class="form-control"  placeholder="Admin Username" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <input type="email" name="adminemail" class="form-control" placeholder="Login Email" required>
                                                    </div>

                                                    <div class="form-group">
                                                        <select name="category" class="form-control" required>
                                                            <option value="">Admin Role</option>
                                                            <option value="General">General</option>
                                                            <option value="Predictor">Predictor</option>
                                                            <option value="Blogger">Blogger</option>
                                                        </select>
                                                    </div>

                                                    <div class="form-group">
                                                        <input type="password" name="adminopkey" class="form-control" placeholder="Operation Key" required maxlength="5">
                                                    </div>
                                                    <h4>Define Password</h4>
                                                    <div class="divider"></div>
                                                    <div class="form-group">
                                                        <input type="password" name="password" class="form-control"  placeholder="Password">
                                                    </div>

                                                    <div class="form-group">
                                                        <input type="password" name="repassword" class="form-control"  placeholder="Confirm Password">
                                                    </div>

                                                    <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                                    <div class="form-group">
                                                        <div id="newadminstatus"></div><br>
                                                        <button class="btn btn-md btn-success" type="submit" id="newadminbtn">Save Changes</button>
                                                    </div>

                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer"></div>
                                </div>
                            </div>
                        </div>

                        <div class="clearfix"></div>
                    </div>

                </div>

            </div>

        </div>
        <!-- /page content -->

        <!-- footer content -->
        <footer>
            <div class="pull-right">
                &copy; STAKEGAINS INC. (2016) | All rights reserved
            </div>
            <div class="clearfix"></div>
        </footer>
        <!-- /footer content -->
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo e(asset('vendors/jquery/dist/jquery.min.js')); ?>"></script>
<!-- Bootstrap -->
<script src="<?php echo e(asset('vendors/bootstrap/dist/js/bootstrap.min.js')); ?>"></script>
<!-- FastClick -->
<script src="<?php echo e(asset('vendors/fastclick/lib/fastclick.js')); ?>"></script>
<!-- NProgress -->
<script src="<?php echo e(asset('vendors/nprogress/nprogress.js')); ?>"></script>
<!-- bootstrap-progressbar -->
<script src="<?php echo e(asset('vendors/bootstrap-progressbar/bootstrap-progressbar.min.js')); ?>"></script>

<?php /*Datatables */ ?>
<script src="<?php echo e(asset('vendors/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-bs/js/dataTables.bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js')); ?>"></script>
<?php /*<script src="<?php echo e(asset('vendors/datatables.net-scroller/js/datatables.scroller.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/jszip/dist/jszip.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/pdfmake/build/pdfmake.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/pdfmake/build/vfs_fonts.js')); ?>"></script>*/ ?>

<!-- Custom Theme Scripts -->
<script src="<?php echo e(asset('js/custom.js')); ?>"></script>
<script src="<?php echo e(asset('js/bootstrap-fileupload.js')); ?>"></script>
<script src="<?php echo e(asset('js/anytime.js')); ?>"></script>
<script src="<?php echo e(asset('js/jquery.table2excel.min.js')); ?>"></script>
<script>
    AnyTime.picker( "matchdate",
            { format: "%d-%m-%Y", firstDOW: 1 } );

    $("#matchtime").AnyTime_picker(
            { format: "%h:%i %p", firstDOW: 1 } );
</script>
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ready(function () {
        $('#datatable-responsive').DataTable({
            "bPaginate": false
        });

        $('#datatable').DataTable({
            "bPaginate": false
        });

        $('#excon').hide();

        $("#exportbtn").click(function(){
            $("#exportthis").table2excel({
                exclude: ".noExl",
                name: "Predictions",
                filename: "PredictionFile"
            });
        });

        $('#refresher').click(function(){
            $(this).html("<span class='fa fa-spin fa-3x fa-spinner'></span>");
            $('#refreshStatus').fadeIn('500').html('Working...');
            $.ajax({
                type: "GET",
                url: "systemRefresh",
                success: function (data) {
                    $('#refresher').html("REFRESH <br>SYSTEM");
                    $('#refreshStatus').html(data).fadeOut(15000);
                }
            });
        });

        $('.admincontrol').click(function(){
            var admincode = $(this).attr('href');
            $('#adminbody').html('Fetching...');
            $.ajax({
                type: "GET",
                url: "admincontrol/"+admincode,
                success: function (data) {
                $('#adminbody').html(data);
                }
            });
        });

        $('.gameview').click(function(){
            var gamecode = $(this).attr('href');
            $('#ebody').html('Fetching...');
            $.ajax({
                type: "GET",
                url: "gamedetails/"+gamecode,
//              data: dataString,
                success: function (data) {
                    console.log(data);
                $('#ebody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.blogview').click(function(){
            var blogcode = $(this).attr('href');
            $('#blogbody').html('Fetching Content...');
            $.ajax({
                type: "GET",
                url: "blogdetails/"+blogcode,
                success: function (data) {
                    console.log(data);
                $('#blogbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.trashleague').click(function(e){
            e.preventDefault();
            var id = $(this).attr('href');
            $('#'+id).hide();
            $.ajax({
                type: "GET",
                url: "trashleague/"+id,
                success: function (data) {
                    console.log(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.updategame').click(function(){
            var gid = $(this).attr('href');
            $('#ubody').html('Fetching Data...');
            $.ajax({
                type: "GET",
                url: "updateprediction/"+gid,
                success: function (data) {
                    $('#ubody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.userdetails').click(function(){
            var uid = $(this).attr('href');
            $('#userinfobody').html('Fetching Data...');
            $.ajax({
                type: "GET",
                url: "userdetails/"+uid,
                success: function (data) {
                    $('#userinfobody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.updateuser').click(function(){
            var uid = $(this).attr('href');
            $('#userbody').html('Fetching Data...');
            $.ajax({
                type: "GET",
                url: "updateuserinfo/"+uid,
                success: function (data) {
                    $('#userbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.upgradeuser').click(function(){
            var uid = $(this).attr('href');
            $('#userupbody').html('Fetching Data...');
            $.ajax({
                type: "GET",
                url: "upgradeuseracct/"+uid,
                success: function (data) {
                    $('#userupbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });
        
        $('.updateblog').click(function(){
            var bid = $(this).attr('href');
            $('#blbody').html('Fetching Data...');
            $.ajax({
                type: "GET",
                url: "updateblog/"+bid,
                success: function (data) {
                    $('#blbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.updateads').click(function(){
            var aid = $(this).attr('href');
            $('#adsbody').html('Fetching Data...');
            $.ajax({
                type: "GET",
                url: "updateads/"+aid,
                success: function (data) {
                    $('#adsbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.addresult').click(function(){
            var id = $(this).attr('href');
            $('#rbody').html('Loading Game Data...');
            $.ajax({
                type: "GET",
                url: "addresult/"+id,
                success: function (data) {
                    $('#rbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.usersettinghref').click(function(){
            var userid = $(this).attr('href');
            $('#abody').html('Fetching...');
            $.ajax({
                type: "GET",
                url: "ajaxusersetting/"+userid,
                success: function (data) {
                    $('#abody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('#adminsetting').submit(function (e) {
            e.preventDefault();
            $('#adminstatus').html('Updating... Please wait');
            $('#adminsettingbtn').prop('disabled', true);

            var dataString = $(this).serialize();
            console.log(dataString);
            $.ajax({
                type: "POST",
                url: "ajaxadminsetting",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#adminsettingbtn').prop('disabled', false);
                        $('#adminstatus').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $('#adminstatus').html(data.encounters);
                        alert(data.encounters);
                        $('#admin').modal('hide');
                    }
                }
            });

        });

        $('#predictionform').submit(function (e) {
            e.preventDefault();
            $('#pstatus').html('Uploading... Please wait');
            $('#predictionbtn').prop('disabled', true);

            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "loadprediction",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#predictionbtn').prop('disabled', false);
                        $('#pstatus').html("<div class='alert alert-danger' style='padding: 4px 8px;'>"+data.encounters+"</div>");
                        console.log(data);
                    }
                    else{
                        $("#predictionform")[0].reset();
                        $('#predictionbtn').prop('disabled', false);
                        alert('PREDICTION LOADED');
                        $('#pstatus').html("<div class='alert alert-success' style='padding: 4px 8px;'>"+data.encounters+"</div>");
                    }
                }
            });

        });

        $('#newleague').submit(function (e) {
            e.preventDefault();
            $('#leaguestatus').html('Adding... Please wait');
            $('#leaguebtn').prop('disabled', true);

            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "loadleague",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#leaguebtn').prop('disabled', false);
                        $('#leaguestatus').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $("#newleague")[0].reset();
                        $('#leaguebtn').prop('disabled', false);
                        $('#leaguestatus').html(data.encounters);
                    }
                }
            });
        });

        $('#newadminform').submit(function (e) {
            e.preventDefault();
            $('#newadminstatus').html('Registering... Please wait');
            $('#newadminbtn').prop('disabled', true);

            var dataString = $(this).serialize();
            console.log(dataString);
            $.ajax({
                type: "POST",
                url: "ajaxnewadmin",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#newadminbtn').prop('disabled', false);
                        $('#newadminstatus').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $('#newadminstatus').html(data.encounters);
                        alert(data.encounters);
                        $('#newadmin').modal('hide');
                    }
                }
            });
        });

        $('.flag').click(function(e){
            e.preventDefault();
            var id = $(this).attr('href');
            $('#tbody').html('Loading Game Data...');
            $.ajax({
                type: "GET",
                url: "marktestimonial/"+id,
                success: function (data) {
                    $('#tbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });

        $('.addftt').click(function(e){
            e.preventDefault();
            var id = $(this).attr('href');
            $('#ftbody').html('Loading Game Data...');
            $.ajax({
                type: "GET",
                url: "otherftrec/"+id,
                success: function (data) {
                    $('#ftbody').html(data);
                },
                failure: function (data) {
                    console.log(data);
                }
            });
        });


        $('.unflag').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#f'+id).css('color', 'black').html('Unmarked Testimonial');
            $.ajax({
                type: "GET",
                url: "unmarktestimonial/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.flaguser').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#f'+id).css('color', 'red').html('USER FLAGGED');
            $.ajax({
                type: "GET",
                url: "flaguser/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.unflaguser').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#f'+id).css('color', 'green').html('USER UNFLAGGED');
            $.ajax({
                type: "GET",
                url: "unflaguser/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.disableuser').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'red').html('USER DISABLED');
            $.ajax({
                type: "GET",
                url: "disableuser/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.enableuser').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'green').html('USER ENABLED');
            $.ajax({
                type: "GET",
                url: "enableuser/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.hided').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'red').html('Unpublished');
            $.ajax({
                type: "GET",
                url: "ajaxhide/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.unhide').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'black').html('Published');
            $.ajax({
                type: "GET",
                url: "ajaxunhide/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('#demomailsender').submit(function (e) {
            e.preventDefault();
            $('#demostatus').html('Sending Demo... Please wait');
            $('#demobtn').prop('disabled', true);

            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "demomail",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#demobtn').prop('disabled', false);
                        $('#demostatus').html(data.encounters);
                    }
                    else{
                        $("#demomailsender")[0].reset();
                        $('#demobtn').prop('disabled', false);
                        $('#demostatus').html(data.encounters);
                    }
                }
            });
        });


        $('.hidethis').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'red').html('UNPUBLISHED');
            $.ajax({
                type: "GET",
                url: "ajaxhideblog/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.unhidethis').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'red').html('PUBLISHED');
            $.ajax({
                type: "GET",
                url: "ajaxunhideblog/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.hidead').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'red').html('Ad Hidden');
            $.ajax({
                type: "GET",
                url: "ajaxhidead/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });

        $('.unhidead').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');
            $('#h'+id).css('color', 'red').html('Ad Unhide');
            $.ajax({
                type: "GET",
                url: "ajaxunhidead/"+id,
                success: function (data) {
                    console.log(data)
                }
            });
        });



        $('.gamedelete').click(function(){
            var gid = $(this).attr('href');
            $('#gid').val(gid);
        });

        $('.blogdelete').click(function(){
            var bid = $(this).attr('href');
            $('#bid').val(bid);
        });

        $('.adsdelete').click(function(){
            var aid = $(this).attr('href');
            $('#adid').val(aid);
        });

        $('.userdelete').click(function(){
            var uid = $(this).attr('href');
            $('#usid').val(uid);
        });

        $('.userdeletehref').click(function(){
            var userid = $(this).attr('href');
            $('#useidd').val(userid);
        });

        $('#gamedeleteform').submit(function (e) {
            e.preventDefault();
            $('#deletestatusbox').html('Deleting... Please wait');
            $('#submitdelete').prop('disabled', true);

            var dataString = $(this).serialize();
//            console.log(dataString);
            $.ajax({
                type: "POST",
                url: "ajaxgamedelete",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#submitdelete').prop('disabled', false);
                        $('#deletestatusbox').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $('#'+data.status).hide();
                        alert(data.encounters);
                        $('#gamedelete').modal('hide');
                    }
                }
            });
        });

        $('#blogdeleteform').submit(function (e) {
            e.preventDefault();
            $('#blogdeletestatusbox').html('Deleting... Please wait');
            $('#blogsubmitdelete').prop('disabled', true);

            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajaxblogdelete",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#blogsubmitdelete').prop('disabled', false);
                        $('#blogdeletestatusbox').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $('#d'+data.status).hide();
                        alert(data.encounters);
                        $('#blogdelete').modal('hide');
                    }
                }
            });
        });

        $('#adsdeleteform').submit(function (e) {
            e.preventDefault();
            $('#adsdeletestatusbox').html('Deleting... Please wait');
            $('#adssubmitdelete').prop('disabled', true);

            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajaxadsdelete",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#adssubmitdelete').prop('disabled', false);
                        $('#adsdeletestatusbox').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $('#d'+data.status).hide();
                        alert(data.encounters);
                        $('#adsdelete').modal('hide');
                    }
                }
            });
        });

        $('#userdeleteform').submit(function (e) {
            e.preventDefault();
            $('#userdeletestatusbox').html('Deleting... Please wait');
            $('#usersubmitdelete').prop('disabled', true);

            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: "ajaxuserdelete",
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#usersubmitdelete').prop('disabled', false);
                        $('#userdeletestatusbox').html(data.encounters);
                        console.log(data);
                    }
                    else{
                        $('#'+data.status).hide();
                        alert(data.encounters);
                        $('#userdelete').modal('hide');
                    }
                }
            });
        });

        $('.notedelete').click(function (e) {
            e.preventDefault();
            var id = $(this).attr('href');

            $.ajax({
                type: "GET",
                url: "ajaxnotedelete/"+id,
                success: function (data) {
                    $('#note'+data).hide();
                }
            });
        });


//        setTimeout(function() {
//            $('#stat').modal('show');
//        }, 3000);
//
//        setTimeout(function() {
//            $('#stat').modal('hide');
//        }, 12000);
    });
</script>
</body>
</html>