
<form action="<?php echo e(route('/addResult')); ?>" method="POST" id="addresultform">
    <div class="container-fluid">
        <div class="col-xs-12">
            <input type="hidden" name="id" value="<?php echo e($game->id); ?>">
            <div class="col-md-5 col-xs-12" style="background: whitesmoke; padding: 15px;">
                <h1 class="text-center"><?php echo e($game->teamOne); ?></h1><hr>

                <div class="form-group col-md-12 col-xs-12">
                    <label for="score1">SCORE/GOAL(S)</label>
                    <input type="number" name="score1" class="form-control" required maxlength="5" min="0" value="<?php echo e($game->teamOneScore); ?>">
                </div>

                <div class="form-group col-md-12 col-xs-12">
                    <label for="status1">STATUS (Won, Loose, Draw)</label>
                    <select name="status1" class="form-control" required>
                        <option value="">Select Option</option>
                        <option value="Won" <?php if($game->teamOneWon=='Won'): ?> selected <?php endif; ?>>Won</option>
                        <option value="Loose" <?php if($game->teamOneWon=='Loose'): ?> selected <?php endif; ?>>Loose</option>
                        <option value="Draw" <?php if($game->teamOneWon=='Draw'): ?> selected <?php endif; ?>>Draw</option>
                    </select>
                </div>

            </div>

            <div class="col-md-2 col-xs-12" style="margin: 10px 0px; background: grey; border-radius: 0px 0px 8px 8px;"><center><span style="padding: 5px 10px; background: grey; color: white; border-radius: 100px; margin-top: -30px;">VS</span></center>
                <br>
                <div class="form-group">
                    <input class="form-control" name="matchdate" id="matchdate" type="text" placeholder="MATCH DATE" required value="<?php echo e($game->gameDate); ?>" disabled>
                </div>
                <div class="form-group">
                    <input class="form-control" name="matchtime" id="matchtime" type="text" placeholder="MATCH TIME" required value="<?php echo e($game->gameTime); ?>" disabled>
                </div>
            </div>

            <div class="col-md-5 col-xs-12" style="background: whitesmoke; padding: 15px;">
                <h1 class="text-center"><?php echo e($game->teamTwo); ?></h1><hr>

                <div class="form-group col-md-12 col-xs-12">
                    <label for="score2">SCORE/GOAL(S)</label>
                    <input type="number" name="score2" class="form-control" required maxlength="5" min="0" value="<?php echo e($game->teamTwoScore); ?>">
                </div>

                <div class="form-group col-md-12 col-xs-12">
                    <label for="status2">STATUS (Won, Loose, Draw)</label>
                    <select name="status2" class="form-control" required>
                        <option value="">Select Option</option>
                        <option value="Won" <?php if($game->teamTwoWon=='Won'): ?> selected <?php endif; ?>>Won</option>
                        <option value="Loose" <?php if($game->teamTwoWon=='Loose'): ?> selected <?php endif; ?>>Loose</option>
                        <option value="Draw" <?php if($game->teamTwoWon=='Draw'): ?> selected <?php endif; ?>>Draw</option>
                    </select>
                </div>

            </div>
        </div>
    </div>
    <hr>
    <div class="container-fluid">
        <?php echo csrf_field(); ?>


        <div id="settingstatus" class="col-xs-6"></div>
        <div class="form-group col-sm-12">
            <button class="btn btn-md btn-success" name="submit" id="submitsetting">SAVE RESULT</button>
        </div>

    </div>
</form>

<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ready(function () {
        $('#addresultform').submit(function (e) {
            e.preventDefault();
            $('#submitsetting').prop('disabled', true).html('SAVING RESULT');
            var url = $(this).attr('action');
            var dataString = $(this).serialize();
            $.ajax({
                type: "POST",
                url: url,
                data: dataString,
                dataType: "JSON",
                success: function(data){
                    if (data.status == 1) {
                        $('#submitsetting').prop('disabled', false).html('SAVE RESULT');
                        swal(data.encounters, '', 'warning');
                    }
                    else{
                        swal(data.encounters, '', 'success');
                        $('#addresult').modal('hide');
                    }
                }
            });

        });
    });
</script>