<?php $__env->startSection('title'); ?>
    eventry.ng | One-Time Accounts
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page'); ?>
    One-Time Accounts
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="col" style="min-height: 323px;;">
        <br><br>
        <?php
        $date = new dateTime();
        $d = $date->format('j F, Y');
        $today = date('d-m-Y');
        ?>
        <table id="datatable-responsive" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
            <thead>
            <tr>
                <th>ID</th>
                <th>FULL NAME</th>
                <th>EMAIL ADDRESS</th>
                <th>PHONE NUMBER</th>
                <th>EVENTS CREATED</th>
                <th>DATE REGISTERED</th>
                <th>NEXT DUE DATE</th>

                <th>Details</th>
                <th>Controls</th>
            </tr>
            </thead>
            <tbody>
            <?php foreach($users->all() as $user): ?>
                <?php

                $creator = count(App\Event::where('creator', $user->id)->get());
                ?>
                <tr>
                    <td class="red"><?php echo e($user->id); ?></td>
                    <td><?php echo e($user->user_name); ?></td>
                    <td><?php echo e($user->email); ?></td>
                    <td><?php echo e($user->phone); ?></td>
                    <td><?php echo e($creator); ?></td>
                    <?php if($user->dateregistered==$today): ?>
                        <td><span class="red">TODAY</span></td>
                    <?php else: ?>
                        <td><?php echo e($user->dateregistered); ?></td>
                    <?php endif; ?>
                    <?php if($user->nextduedate==$today): ?>
                        <td><span class="red">TODAY</span></td>
                    <?php else: ?>
                        <td><?php echo e($user->nextduedate); ?></td>
                    <?php endif; ?>

                    <?php if($user->accounttype=='FREE'): ?>
                        <td><span class="red"><span class="fa fa-user-times"></span></span></td>
                    <?php else: ?>
                        <td><a class="creatorview" href="<?php echo e($user->id); ?>" data-target="#creator" data-toggle="modal"><span style="color: brown;">DETAILS</span></a></td>
                    <?php endif; ?>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-xs dropdown-toggle" data-toggle="dropdown">
                                Actions
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu pull-right" role="menu" style="background: whitesmoke; -webkit-box-shadow: inset 0px 0px 10px grey;-moz-box-shadow: inset 0px 0px 10px grey;box-shadow: inset 0px 0px 10px grey;">
                                <li style="cursor: pointer;"><a class="usersettinghref" href="<?php echo e($user->id); ?>" data-target="#usersetting" data-toggle="modal"><span class="fa fa-cogs"> Settings</span></a>
                                <li style="cursor: pointer;"><a class="userdeletehref" href="<?php echo e($user->id); ?>" data-target="#userdelete" data-toggle="modal"><span class="fa fa-trash"> Delete</span></a>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>