<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="'Deji Busari & Folarin Farinto">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <link rel="SHORTCUT ICON" href="<?php echo e(asset('images/sglogo.png')); ?>">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link href="https://fonts.googleapis.com/css?family=Changa" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">
    <!-- Bootstrap -->
    <link href="<?php echo e(asset('vendors/bootstrap/dist/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="<?php echo e(asset('vendors/font-awesome/css/font-awesome.min.css')); ?>" rel="stylesheet">
    <!-- iCheck -->
    <link href="<?php echo e(asset('vendors/iCheck/skins/flat/green.css')); ?>" rel="stylesheet">
    <!-- bootstrap-progressbar -->
    <link href="<?php echo e(asset('vendors/bootstrap-progressbar/css/bootstrap-progressbar-3.3.4.min.css')); ?>" rel="stylesheet">
    
    <?php /*DATA TABLES*/ ?>
    <link href="<?php echo e(asset('vendors/datatables.net-bs/css/dataTables.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-buttons-bs/css/buttons.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-fixedheader-bs/css/fixedHeader.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-responsive-bs/css/responsive.bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('vendors/datatables.net-scroller-bs/css/scroller.bootstrap.min.css')); ?>" rel="stylesheet">
    
    <!-- Custom Theme Style -->
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/bootstrap-fileupload.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/anytime.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('summernote/summernote.css')); ?>" rel="stylesheet">
</head>

<body class="nav-md" style="font-family: 'Changa', sans-serif;">
<?php
if(Auth::check()){
    $admin = Auth::user();
}
?>
<div class="container body">
    <div class="main_container">
        <div class="col-md-3 left_col">
            <div class="left_col scroll-view">
                <div class="navbar nav_title" style="border: 0; margin-bottom: 20px; height: 100px;">
                    <br>
                    <a href="<?php echo e(url('/home')); ?>" class="site_title" style="height: 100px;"><span><img src="<?php echo e(asset('images/stakelogo.png')); ?>" class="img-responsive" style="max-height: 100px;"></span></a>
                </div>
                <!-- menu profile quick info -->
                <div class="profile">
                    <div class="profile_pic">
                        <?php if($admin->dp!=NULL): ?><img src="<?php echo e(asset('images')); ?>/<?php echo e($admin->dp); ?>" alt="" class="img-circle profile_img" /><?php else: ?><img src="<?php echo e(asset('images/user.png')); ?>" alt="" class="img-circle profile_img" /><?php endif; ?>
                    </div>
                    <div class="profile_info" style="margin-bottom: 30px;">
                        <span>Welcome,</span>
                        <h2>

                            <?php echo e($admin->name); ?></h2>
                    </div>
                </div>
                <!-- /menu profile quick info -->

                <br />

                <!-- sidebar menu -->
                <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
                    <div class="menu_section">
                        <ul class="nav side-menu">
                            <li><a href="<?php echo e(url('/home')); ?>"><i class="fa fa-dashboard"></i> Dashboard</a></li>
                            <?php if($admin->category=='Super' || $admin->category=='Predictor'): ?>
                            <li><a><i class="fa fa-random"></i> PREDICTIONS <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/newgame')); ?>">Add New </a>
                                    </li>
                                    <li><a href="<?php echo e(url('/predictions')); ?>">Manage Existing </a>
                                    </li>
                                    <li><a style="color: red!important;;" data-target="#archiver" data-toggle="modal">MASS GAME ARCHIVE*R </a>
                                    </li>
                                    <li><a href="<?php echo e(url('/archive')); ?>">Manage Archive</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/testimonials')); ?>">Testimonials </a>
                                    </li>
                                </ul>
                            </li>
                            <?php endif; ?>
                            <?php if($admin->category=='Super' || $admin->category=='Blogger'  || $admin->category=='General'): ?>
                            <li><a><i class="fa fa-share-alt"></i> BLOG <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/nblog')); ?>">Add News</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/blogs')); ?>">Managing News</a>
                                    </li>
                                </ul>
                            </li>
                            <?php endif; ?>
                            <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                            <li><a><i class="fa fa-users"></i> MEMBERSHIP <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/allmembers')); ?>">View/Manage </a>
                                    </li>
                                    <li><a class="text-danger" style="color: chartreuse!important;;">SUBSCRIBED MEMBERS<span class="fa fa-chevron-down"></span></a>
                                        <ul class="nav child_menu">
                                            <li><a href="<?php echo e(route('/subscribed')); ?>" style="color: chartreuse!important;;">Currently Active</a>
                                            </li>
                                            <li><a href="<?php echo e(route('/expired')); ?>" style="color: red!important;;">Expired Users</a>
                                            </li>
                                        </ul>
                                    </li>
                                    <li><a href="<?php echo e(url('/dmembers')); ?>">Disabled Members </a>
                                    </li>
                                    <li><a href="<?php echo e(url('/fmembers')); ?>">Flagged Members </a>
                                    </li>
                                </ul>
                            </li>
                            <li><a><i class="fa fa-ticket"></i> ADs <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/newads')); ?>">Post Ads</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/manageads')); ?>">Manage Ads</a>
                                    </li>
                                </ul>
                            </li>

                            <li><a><i class="fa fa-soccer-ball-o"></i> UPCOMING LEAGUE <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/slidenote')); ?>">Add New</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/notemanage')); ?>">Manage Existing</a>
                                    </li>
                                </ul>
                            </li>

                            <li><a><i class="fa fa-soccer-ball-o"></i> LEAGUES <span class="fa fa-chevron-down"></span></a>
                                <ul class="nav child_menu">
                                    <li><a href="<?php echo e(url('/loadleague')); ?>">Load Leagues</a>
                                    </li>
                                    <li><a href="<?php echo e(url('/manageleague')); ?>">Manage Leagues</a>
                                    </li>
                                </ul>
                            </li>

                                <li><a><i class="fa fa-envelope"></i> EMAIL MANAGER <span class="fa fa-chevron-down"></span></a>
                                    <ul class="nav child_menu">
                                        <li><a href="<?php echo e(url('/bulkmail')); ?>">To All Member</a></li>
                                        <li><a class="text-danger" style="color: chartreuse!important;;">TO SUBSCRIBED MEMBERS<span class="fa fa-chevron-down"></span></a>
                                            <ul class="nav child_menu">
                                                <li><a href="<?php echo e(route('/bulkActive')); ?>" style="color: chartreuse!important;;">Currently Active</a>
                                                </li>
                                                <li><a href="<?php echo e(route('/bulkExpired')); ?>" style="color: red!important;;">Expired Users</a>
                                                </li>
                                            </ul>
                                        </li>
                                        <li><a href="<?php echo e(route('/individualMail')); ?>">To Individual(s)</a></li>
                                    </ul>
                                </li>
                                <li class="bg-danger"><a href="<?php echo e(route('/planManager')); ?>" style="color: red!important;;"><i class="fa fa-credit-card-alt"></i> SUB. PLAN MANAGER</a></li>


                            <?php endif; ?>
                        </ul>
                    </div>

                </div>
                <!-- /sidebar menu -->

                <!-- /menu footer buttons -->
                <div class="sidebar-footer hidden-small">

                </div>
                <!-- /menu footer buttons -->
            </div>
        </div>

        <!-- top navigation -->
        <div class="top_nav">

            <div class="nav_menu">
                <nav class="" role="navigation">
                    <div class="nav toggle">
                        <a id="menu_toggle"><i class="fa fa-bars"></i></a>
                    </div>
                    <ul class="nav navbar-nav navbar-right">
                        <li class="">
                            <a href="javascript:;" class="user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                <?php if($admin->dp!=NULL): ?><img src="<?php echo e(asset('images')); ?>/<?php echo e($admin->dp); ?>" alt="" /><?php else: ?><img src="<?php echo e(asset('images/user.png')); ?>" alt="" /><?php endif; ?><?php echo e($admin->username); ?>

                                <span class=" fa fa-angle-down"></span>
                            </a>
                            <ul class="dropdown-menu dropdown-usermenu pull-right">
                                <li><a href="#" data-target="#admin" data-toggle="modal">  Profile</a>
                                </li>
                                <li>
                                    <?php if($admin->category=='Super'): ?>
                                    <a href="#" data-target="#newadmin" data-toggle="modal">
                                        <span>Create New Admin</span>
                                    </a>

                                    <a href="<?php echo e(url('/admins')); ?>">
                                        <span>Manage Admin</span>
                                    </a>
                                </li>
                                <?php endif; ?>
                                <li><a href="<?php echo e(url('/logout')); ?>"><i class="fa fa-sign-out pull-right"></i> Log Out</a>
                                </li>
                            </ul>
                        </li>
                        <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                        <li>
                            <a href="#" data-target="#textRotator" data-toggle="modal" class="sliderLoader"><button class="btn btn-sm btn-danger">TEXT ROTATOR</button></a>
                        </li>
                            <li>
                                <a href="<?php echo e(route('/promotions')); ?>"><button class="btn btn-sm btn-success">PROMOTION</button></a>
                            </li>
                            <li class="bg-success">
                                <a href="javascript:;" class="user-profile dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                    SUBSCRIPTION GIFT
                                    <span class=" fa fa-angle-down"></span>
                                </a>
                                <ul class="dropdown-menu dropdown-usermenu pull-right">
                                    <li><a href="#" data-target="#subscribedMembers" data-toggle="modal">  To All Subscribed Members</a></li>
                                    <li><a href="#" data-target="#lapsedMembers" data-toggle="modal">  To All Lapsed Members</a></li>
                                </ul>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            </div>

        </div>
        <!-- /top navigation -->


        <!-- page content -->
        <div class="right_col" role="main">

            <!-- top tiles -->
            <div class="row tile_count">
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-random"></i> Predictions</span>
                    <div class="count" id="predictHolder"><i class="fa fa-spin fa-spinner"></i></div>
                    <?php if($admin->category=='Super' || $admin->category=='Predictor'): ?>
                    <a href="<?php echo e(url('/predictions')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-calendar-check-o"></i> Testimonials</span>
                    <div class="count red" id="testimonialHolder"><i class="fa fa-spin fa-spinner"></i></div>
                    <?php if($admin->category=='Super' || $admin->category=='Predictor'): ?>
                    <a href="<?php echo e(url('/testimonials')); ?>">View/Manage</a>
                    <?php endif; ?>
                </div>
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-users"></i> Members</span>
                    <div class="count" id="userHolder"><i class="fa fa-spin fa-spinner"></i></div>
                    <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                    <a href="<?php echo e(url('/allmembers')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-share-alt"></i> Blog Posts</span>
                    <div class="count red" id="blogHolder"><i class="fa fa-spin fa-spinner"></i></div>
                    <?php if($admin->category=='Super' || $admin->category=='Blogger'  || $admin->category=='General'): ?>
                    <a href="<?php echo e(url('/blogs')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>
                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-ticket"></i> Ads Posts</span>
                    <div class="count" id="adsHolder"><i class="fa fa-spin fa-spinner"></i></div>
                    <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                    <a href="<?php echo e(url('/manageads')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>

                <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                    <span class="count_top"><i class="fa fa-ticket"></i> Leagues Added</span>
                    <div class="count" id="leagueHolder"><i class="fa fa-spin fa-spinner"></i></div>
                    <?php if($admin->category=='Super' || $admin->category=='General'): ?>
                    <a href="<?php echo e(url('/manageleague')); ?>">View/Manage</a>
                        <?php endif; ?>
                </div>



            </div>
            <!-- /top tiles -->
            <div class="row">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="dashboard_graph" style="height: 400px; overflow: auto;">

                        <div class="row x_title">
                            <div class="col-md-12">
                                <h3>Dashboard Controls: <span class="green"><?php echo $__env->yieldContent('page'); ?></span></h3>
                            </div>

                        </div>

                        <?php echo $__env->yieldContent('content'); ?>

                        <?php echo $__env->make('modals.modal', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

                        <div class="clearfix"></div>
                    </div>

                </div>

            </div>

        </div>
        <!-- /page content -->
        <?php if($admin->category=='Super' || $admin->category=='General'): ?>
        <section class="drawer">
            <!-- <div> -->
            <header class="clickme">Sliders Manager</header>
            <!-- </div> -->
            <div class="drawer-content">
                <div class="drawer-items">
                    <ul>
                        <li>
                            <a href="<?php echo e(route('/feedbackLoader')); ?>">
                                <div class="title">Feedback Review</div>
                                <div class="time">Approve/Publish</div>
                                <div class="location">Disapprove/Trash</div>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('/sliderManager')); ?>">
                                <div class="title">Image Slider</div>
                                <div class="time">Frontend Image</div>
                                <div class="location">Slider Manager</div>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('/shotManager')); ?>">
                                <div class="title">Testimonial Shot</div>
                                <div class="time">Screenshot Uploader</div>
                                <div class="location">& Manager</div>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </section>
        <?php endif; ?>

        <!-- footer content -->
        <footer>
            <div class="pull-right">
                &copy; STAKEGAINS INC. (2016 - <?php echo e(date('Y')); ?>) | All rights reserved
            </div>
            <div class="clearfix"></div>
        </footer>
        <!-- /footer content -->
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo e(asset('vendors/jquery/dist/jquery.min.js')); ?>"></script>
<!-- Bootstrap -->
<script src="<?php echo e(asset('vendors/bootstrap/dist/js/bootstrap.min.js')); ?>"></script>
<!-- FastClick -->
<script src="<?php echo e(asset('vendors/fastclick/lib/fastclick.js')); ?>"></script>
<!-- NProgress -->
<script src="<?php echo e(asset('vendors/nprogress/nprogress.js')); ?>"></script>
<!-- bootstrap-progressbar -->
<script src="<?php echo e(asset('vendors/bootstrap-progressbar/bootstrap-progressbar.min.js')); ?>"></script>

<?php /*Datatables */ ?>
<script src="<?php echo e(asset('vendors/datatables.net/js/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-bs/js/dataTables.bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendors/datatables.net-responsive-bs/js/responsive.bootstrap.js')); ?>"></script>
<?php /*<script src="<?php echo e(asset('vendors/datatables.net-scroller/js/datatables.scroller.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/jszip/dist/jszip.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/pdfmake/build/pdfmake.min.js')); ?>"></script>*/ ?>
<?php /*<script src="<?php echo e(asset('vendors/pdfmake/build/vfs_fonts.js')); ?>"></script>*/ ?>

<!-- Custom Theme Scripts -->
<script src="<?php echo e(asset('js/custom.js')); ?>"></script>
<script src="<?php echo e(asset('summernote/summernote.js')); ?>"></script>
<script src="<?php echo e(asset('js/bootstrap-fileupload.js')); ?>"></script>
<script src="<?php echo e(asset('js/anytime.js')); ?>"></script>
<script src="<?php echo e(asset('js/jquery.table2excel.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/jquery.slidedrawer.min.js')); ?>"></script>
<script>
    AnyTime.picker( "matchdate",
            { format: "%d-%m-%Y", firstDOW: 1 } );

    $("#matchtime").AnyTime_picker(
            { format: "%h:%i %p", firstDOW: 1 } );
</script>
<script>
    $(function(){
        $('.drawer').slideDrawer({
            showDrawer: false,
            // slideTimeout: true,
            slideSpeed: 600,
            slideTimeoutCount: 3000
        });
    });

    $(document).ready(function () {

        countPredictions();

        function countPredictions() {
            boilerCounter('predictions', 'predictHolder');
            countTestimonial();
        }

        function countTestimonial() {
            boilerCounter('testimonials', 'testimonialHolder');
            countBlog();
        }

        function countBlog() {
            boilerCounter('blogs', 'blogHolder');
            countAds();
        }

        function countAds() {
            boilerCounter('ads', 'adsHolder');
            countLeague();
        }

        function countLeague() {
            boilerCounter('leagues', 'leagueHolder');
            countMember();
        }

        function countMember() {
            boilerCounter('members', 'userHolder');
        }

        function boilerCounter(key, holder) {
            $.ajax({
                type: "GET",
                url: "counter/"+key,
                success: function (data) {
                    $('#'+holder).html(data);
                }
            });
        }
    });
</script>
<script src="<?php echo e(asset('js/native.js')); ?>"></script>
</body>
</html>