<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <!-- Meta, title, CSS, favicons, etc. -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="author" content="'Deji Busari">
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <link rel="SHORTCUT ICON" href="{{asset('images/favicon.jpg')}}">
    <title>PAYMENT INVOICE FOR {{$receipt->transactionID}}</title>
    <link href="https://fonts.googleapis.com/css?family=Changa" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">
    <!-- Bootstrap -->
    <link href="{{asset('vendors/bootstrap/dist/css/bootstrap.min.css')}}" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="{{asset('vendors/font-awesome/css/font-awesome.min.css')}}" rel="stylesheet">

    <!-- Custom Theme Style -->
    <link href="{{asset('css/custom.css')}}" rel="stylesheet">
    <link href="{{asset('css/style.css')}}" rel="stylesheet">
</head>
<body class="nav-md" style="font-family: 'Changa', sans-serif;">
<!-- jQuery -->

<div class="container">
    <div class="row">
        <div class="col-sm-6 col-sm-offset-3 col-xs-12" style="margin-top: 50px; margin-bottom: 20px; background: white; border: 1px solid whitesmoke; padding: 0px; border-radius: 8px;">
            <div class="well">
                <center>
                    <img src="{{asset('images/sportpesa.png')}}" class="img-responsive" style="max-height: 55px;" alt="Doctor Odds">
                </center>
                <div class="row">
                    <hr>
                    <div class="col-sm-8 col-sm-offset-2 col-xs-12">
                        <center>
                            <h3>PAYMENT INVOICE <br><small>{{\Carbon\Carbon::parse($receipt->created_at)->format('D d M, Y h:ia')}}</small>
                                <br>${{number_format($receipt->plan->dollarPrice, 2)}}</h3>
                        </center>
                    </div>
                </div>
            </div>
            <div class="col-xs-12">
                <center>
                    <h4>Transaction Details</h4>
                </center>
                <table class="table table-striped table-hover table-bordered">
                    <thead>
                    <tr>
                        <th class="text-right">Customer Name:</th>
                        <td>{{$customer->full_name}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">Email Address:</th>
                        <td>{{$customer->email}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">Phone Number:</th>
                        <td>{{$customer->phone}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">Amount:</th>
                        <td>${{number_format($receipt->plan->dollarPrice, 2)}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">Transaction ID:</th>
                        <td>{{$receipt->transactionID}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">Reference:</th>
                        <td>{{$receipt->transactionRef}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">Plan:</th>
                        <td>{{$receipt->plan->category}} ({{$receipt->plan->accessTime}})</td>
                    </tr>
                    <tr>
                        <th class="text-right">Date Subscribed:</th>
                        <td>{{\Carbon\Carbon::parse($receipt->created_at)->format('D d M, Y h:ia')}}</td>
                    </tr>
                    <tr>
                        <th class="text-right">Subscription Expired:</th>
                        <?php
                            $next = strtotime('+'.$receipt->plan->accessTime, strtotime($receipt->created_at));
                            $nextDue = date("Y-m-d H:i:s", $next);
                        ?>
                        <td>{{\Carbon\Carbon::parse($nextDue)->format('D d M, Y h:ia')}}</td>
                    </tr>
                    </thead>
                </table>
                <center>
                    All rights reserved.
                    (c) 2019 - Sportspesa Tips <br>
                    For inquiries or complaint, email us via soccabet6@gmail.com
                    <br><br>
                </center>
            </div>
        </div>
    </div>
</div>
<script src="{{asset('vendors/jquery/dist/jquery.min.js')}}"></script>
<!-- Bootstrap -->
<script src="{{asset('vendors/bootstrap/dist/js/bootstrap.min.js')}}"></script>
<!-- Custom Theme Scripts -->
<script src="{{asset('js/native.js')}}"></script>
</body>
</html>