@extends('layouts.master')

@section('title')
    SPORTPESA | Admin Home
@endsection
@section('content')
    <?php
    if(Auth::check()){
        $admin = Auth::user();
    }
    ?>
    <div class="col">
        <!-- top tiles -->
        <div class="row tile_count">
            <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-random"></i> Free Tips</span>
                <div class="count" id="predictHolder"><i class="fa fa-spin fa-spinner"></i></div>
                @if($admin->category=='Super' || $admin->category=='Predictor')
                    <a href="{{url('/predictions')}}">View/Manage</a>
                @endif
            </div>
            <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-share-alt"></i> VIP Tips</span>
                <div class="count red" id="blogHolder"><i class="fa fa-spin fa-spinner"></i></div>
                @if($admin->category=='Super' || $admin->category=='Predictor')
                    <a href="{{route('/VIPpredictions')}}">View/Manage</a>
                @endif
            </div>
            <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-calendar-check-o"></i> Testimonials</span>
                <div class="count red" id="testimonialHolder"><i class="fa fa-spin fa-spinner"></i></div>
                @if($admin->category=='Super' || $admin->category=='Predictor')
                    <a href="{{url('/testimonials')}}">View/Manage</a>
                @endif
            </div>
            <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-users"></i> Members</span>
                <div class="count" id="userHolder"><i class="fa fa-spin fa-spinner"></i></div>
                @if($admin->category=='Super' || $admin->category=='General')
                    <a href="{{url('/allmembers')}}">View/Manage</a>
                @endif
            </div>
            <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-user-plus"></i> Subscribers</span>
                <div class="count" id="adsHolder"><i class="fa fa-spin fa-spinner"></i></div>
                @if($admin->category=='Super' || $admin->category=='General')
                    <a href="{{url('/subscribed')}}">View/Manage</a>
                @endif
            </div>

            <div class="col-md-2 col-sm-3 col-xs-6 tile_stats_count">
                <span class="count_top"><i class="fa fa-user-times"></i> Expired Subscribers</span>
                <div class="count" id="leagueHolder"><i class="fa fa-spin fa-spinner"></i></div>
                @if($admin->category=='Super' || $admin->category=='General')
                    <a href="{{route('/expired')}}">View/Manage</a>
                @endif
            </div>
        </div>
        <!-- /top tiles -->
        <br><br>
        <?php
        $date = new dateTime();
        $d = $date->format('D j F, Y');


        ?>
        <?php
        if(Auth::check()){
            $admin = Auth::user();
        }
        ?>

        @if(isset($mail))
            <script>
                alert({{$mail}});
            </script>
        @endif
        <center><h2 style="margin-bottom: -10px;">{{$d}}</h2>
            <blockquote><h1>Welcome, {{$admin->name}}</h1></blockquote>

            <button class="btn btn-lg btn-danger" style="white-space: normal!important; padding: 40px 30px; border-radius: 100px;" id="refresher">REFRESH <br>SYSTEM</button><br>
            <span id="refreshStatus" class="text-danger"></span>
            <br>
        </center>
        @if(isset($success))
            <script>alert('{{$success}}');</script>
        @endif
    </div>
@endsection

@section('levelJS')
    <script>
        $(document).ready(function () {
            countPredictions();

            function countPredictions() {
                boilerCounter('predictions', 'predictHolder');
                countTestimonial();
            }

            function countTestimonial() {
                boilerCounter('testimonials', 'testimonialHolder');
                countBlog();
            }

            function countBlog() {
                boilerCounter('blogs', 'blogHolder');
                countAds();
            }

            function countAds() {
                boilerCounter('ads', 'adsHolder');
                countLeague();
            }

            function countLeague() {
                boilerCounter('leagues', 'leagueHolder');
                countMember();
            }

            function countMember() {
                boilerCounter('members', 'userHolder');
            }

            function boilerCounter(key, holder) {
                $.ajax({
                    type: "GET",
                    url: "counter/"+key,
                    success: function (data) {
                        $('#'+holder).html(data);
                    }
                });
            }
        });
    </script>
@endsection


