@extends('layouts.master')

@section('title')
    SPORTPESA | ALL VIP PREDICTIONS
@endsection
@section('page')
    VIP Predictions
@endsection
@section('content')

    <div class="col" style="min-height: 323px;;">
        <br><br>
        <?php
        $date = new dateTime();
        $d = $date->format('j F, Y');
        ?>
        {{$allprediction->render()}}
        <table id="datatable" class="table table-striped table-bordered nowrap" cellspacing="0" width="100%">
            <thead>
            <tr>
                <th>REL</th>
                <th>Match Date</th>
                <th>League</th>
                <th></th>
                <th class="red" style="background: #b1f10c; text-align: center"></th>
                <th></th>
                <th>Presence</th>
                <th>Result</th>
                <th>Details</th>
                <th>Controls</th>
            </tr>
            </thead>
            <tbody>
            <?php
            $sn = 0;
            ?>
            @foreach($allprediction->all() as $prediction)
                <?php
                $sn++;
                ?>
                <tr id="pred{{$prediction->id}}" @if($prediction->teamOneWon!='') style="background: lightgreen; color: darkgreen" @endif>
                    <td class="red">{{$sn}}</td>
                    <td>
                        {{$prediction->gameDate}} <br>
                        {{$prediction->gameTime}}
                    </td>
                    <td>{{$prediction->league}}</td>
                    <td>{{$prediction->teamOne}}</td>
                    <td class="red" style="background: #b1f10c; text-align: center; font-weight: bold">VS</td>

                    <td>{{$prediction->teamTwo}}</td>
                    {{--                <td>{{$prediction->drawOdd}}</td>--}}
                    <td>
                        <div class="tags">
                            <small>
                                @if($prediction->multiBetOne!='No') <span class="tag">Multibet 1: <strong>{{$prediction->multiBetOneTip}} - ({{$prediction->multiBetOneOdds}})</strong></span> @endif
                                    @if($prediction->multiBetTwo!='No') <span class="tag">Multibet 2: <strong>{{$prediction->multiBetTwoTip}} - ({{$prediction->multiBetTwoOdds}})</strong></span> @endif
                                        @if($prediction->multiBetThree!='No') <span class="tag">Multibet 3: <strong>{{$prediction->multiBetThreeTip}} - ({{$prediction->multiBetThreeOdds}})</strong></span> @endif
                                            @if($prediction->super!='No') <span class="tag">Super: <strong>{{$prediction->superTip}} - ({{$prediction->superOdds}})</strong></span> @endif
                                @if($prediction->HTFT!='No') <span class="tag">HT/FT: <strong>{{$prediction->HTFT}} - ({{$prediction->HTFTOdds}})</strong></span> @endif
                                @if($prediction->mega!='No') <span class="tag">Mega: <strong>{{$prediction->megaTip}} - ({{$prediction->megaOdds}})</strong></span> @endif
                                @if($prediction->midWeek!='No') <span class="tag">Midweek: <strong>{{$prediction->midWeekTip}} - ({{$prediction->midWeekOdds}})</strong></span> @endif
                            </small>
                        </div>
                    </td>
                    <td>@if($prediction->teamOneWon) {{$prediction->teamOneScore}} : {{$prediction->teamTwoScore}} @endif</td>
                    <td><a class="gameview" href="" data-url="{{route('/gamedetails')}}/{{$prediction->id}}/Prediction" data-target="#gamedetail" data-toggle="modal"><span style="color: green;"><span class="fa fa-eye"></span> VIEW</span></a></td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-xs dropdown-toggle" data-toggle="dropdown">
                                Actions
                                <span class="caret"></span>
                            </button>
                            <ul class="dropdown-menu pull-right" role="menu" style="background: whitesmoke; -webkit-box-shadow: inset 0px 0px 10px grey;-moz-box-shadow: inset 0px 0px 10px grey;box-shadow: inset 0px 0px 10px grey;">
                                {{--<li style="cursor: pointer;"><a style="color: red;" class="archiveGame" data-id="{{$prediction->id}}">ARCHIVE THIS</a>--}}
                                <li style="cursor: pointer;"><a class="updategame" data-in="Prediction" href="" data-url="{{route('/updateVIPprediction')}}/{{$prediction->id}}/Prediction" data-target="#updategame" data-toggle="modal">EDIT/UPDATE</a>
                                <li style="cursor: pointer;"><a class="addresult" href="" data-url="{{route('/addresult')}}/{{$prediction->id}}" data-target="#addresult" data-toggle="modal">ADD RESULT & TESTIMONIAL</a>
                                @if($prediction->display=='0')
                                    <li style="cursor: pointer;"><a class="hided" data-in="Prediction" href="" data-url="{{route('/ajaxhide')}}/{{$prediction->id}}/Prediction" id="h{{$prediction->id}}">UNPUBLISH</a>
                                @else
                                    <li style="cursor: pointer;"><a class="unhide" data-in="Prediction" href="" data-url="{{route('/ajaxunhide')}}/{{$prediction->id}}/Prediction" id="h{{$prediction->id}}"><span style="color: green;">PUBLISH</span></a>
                                @endif

                                <li style="cursor: pointer;"><a class="gamedelete" data-in="Prediction" data-url="{{route('/ajaxgamedelete')}}/{{$prediction->id}}/Prediction" data-id="" href="">DELETE</a>
                                </li>
                            </ul>
                        </div>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
        {{$allprediction->render()}}
    </div>

@endsection
