<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePredictionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('predictions', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('creator');
            $table->string('gameDate');
            $table->string('gameTime');
            $table->string('teamOne');
            $table->string('teamOneForm')->nullable();
            $table->string('teamOneOdds');
            $table->string('teamTwo');
            $table->string('teamTwoForm')->nullable();
            $table->string('teamTwoOdds');
            $table->string('drawOdd');
            $table->string('league');
            $table->string('freePick')->nullable();
            $table->string('upcomingGame')->nullable();
            $table->string('FTRecommendation')->nullable();
            $table->string('oneFiveGoals')->nullable();
            $table->string('doubleChance')->nullable();
            $table->string('twoFiveGoals')->nullable();
            $table->string('overZeroFiveHT')->nullable();
            $table->string('BTTS')->nullable();
            $table->string('directWins')->nullable();
            $table->string('matchCorners')->nullable();
            $table->string('drawNoBet')->nullable();

            $table->string('multiBetOne')->nullable();
            $table->string('multiBetOneTip')->nullable();
            $table->string('multiBetOneOdds')->nullable();

            $table->string('multiBetTwo')->nullable();
            $table->string('multiBetTwoTip')->nullable();
            $table->string('multiBetTwoOdds')->nullable();

            $table->string('multiBetThree')->nullable();
            $table->string('multiBetThreeTip')->nullable();
            $table->string('multiBetThreeOdds')->nullable();

            $table->string('super')->nullable();
            $table->string('superTip')->nullable();
            $table->string('superOdds')->nullable();

            $table->string('HTFT')->nullable();
            $table->string('HTFTOdds')->nullable();

            $table->string('mega')->nullable();
            $table->string('megaTip')->nullable();
            $table->string('megaOdds')->nullable();

            $table->string('midWeek')->nullable();
            $table->string('midWeekTip')->nullable();
            $table->string('midWeekOdds')->nullable();

            $table->text('moreOption')->nullable();

            $table->boolean('testimonial')->nullable();
            $table->string('testimonialValue')->nullable();
            $table->integer('cornerStatus')->default('0');
            $table->string('cornerResult')->nullable();
            $table->integer('teamOneScore')->nullable();
            $table->integer('teamTwoScore')->nullable();
            $table->string('teamOneWon')->nullable();
            $table->string('teamTwoWon')->nullable();

            $table->boolean('status')->default('0');
            $table->boolean('display')->default('0');
            $table->boolean('other')->default('0');
            $table->boolean('gameType')->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('predictions');
    }
}
