<?php

namespace App\Http\Controllers;

use App\Archive;
use App\League;
use App\Prediction;
use App\ResponseFacade;
use Illuminate\Http\Request;

use App\Http\Requests;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class PredictionController extends Controller
{

    public function getNewPrediction(League $league)
    {
        $allLeagues = $league->getLeagues();
        return view('newgame', compact('allLeagues'));
    }

    public function getNewVIPPrediction(League $league)
    {
        $allLeagues = $league->getLeagues();
        return view('newVIPgame', compact('allLeagues'));
    }

    public function getPredictions()
    {
        $category = Auth::user()->category;
        $id = Auth::user()->id;

        if($category=='Super'){
            $predict = Prediction::where('gameType',0)->latest('created_at')->paginate(600);
        }
        else {
            $predict = Prediction::where('gameType',0)->where('creator', $id)->latest('created_at')->paginate(600);
        }
        return view('/predictions', ['allprediction' => $predict]);
    }

    public function getVIPPredictions($key=null)
    {
        $allprediction = Prediction::where('gameType',1)->latest('created_at')->paginate(600);
//        $theDates = Prediction::where('gameType',1)->where($key, 'Yes')->latest('gameDate')->distinct()->get(['gameDate']);

        return view('/VIPpredictions', compact('allprediction'));
    }

    public function ajaxGameUpdate($gid, $datain)
    {
        if($datain=='Prediction')
        {
            $game = Prediction::where('id', $gid)->first();
            return view('ajaxfiles.settings', ['game' => $game, 'datain'=>$datain]);
        }
        else{
            $game = Archive::where('id', $gid)->first();
            return view('ajaxfiles.settings', ['game' => $game, 'datain'=>$datain]);
        }
    }

    public function ajaxVIPGameUpdate($gid, $datain)
    {
        if($datain=='Prediction')
        {
            $game = Prediction::where('id', $gid)->first();
            return view('ajaxfiles.settingVIP', ['game' => $game, 'datain'=>$datain]);
        }
        else{
            $game = Archive::where('id', $gid)->first();
            return view('ajaxfiles.settingVIP', ['game' => $game, 'datain'=>$datain]);
        }
    }

    public function ajaxGameDetail($gamecode, $datain)
    {
        if($datain=='Prediction'){
            $game = Prediction::where('id', $gamecode)->first();
        }
        else{
            $game = Archive::where('id', $gamecode)->first();
        }
        return view('ajaxfiles.gamedetail', ['game' => $game]);
    }

    public function archives()
    {
        $category = Auth::user()->category;
        $id = Auth::user()->id;

        if($category=='Super'){
            $predict = Archive::orderBy('id', 'DESC')->paginate(600);
            return view('/archive', ['allprediction' => $predict]);
        }
        else {
            $predict = Archive::where('creator', $id)->orderBy('id', 'DESC')->paginate(600);
            return view('/archive', ['allprediction' => $predict]);
        }
    }

    public function allTestimonials()
    {
        $testi = Prediction::where('testimonial', '1')->latest('created_at')->get();
        return view('/testimonials', ['alltestimonials' => $testi]);
    }

    public function postNewPrediction(Request $request, Prediction $prediction)
    {
        $data = $request->except('_token');
        $validate = Validator::make($data, [
            'teamOne' => 'string|required',
            'gameDate' => 'string|required',
            'gameTime' => 'string|required',
            'teamTwo' => 'string|required',
            'league' => 'string|required',
        ]);
        if ($validate->fails()) ResponseFacade::validationMessage('All * Fields are required');
//        $prediction->validateInput($request);

        $prediction->checkValidate($request);
        $game = array_add($data, 'creator', Auth::user()->id);
        $prediction->create($game);

        ResponseFacade::validationMessage('Ok', '0');
    }



    public function postGameUpdate(Request $request, $id, $dataIn, Prediction $prediction, Archive $archive)
    {
        $data = $request->except('_token');
        $prediction->validateInput($request);
        $prediction->checkValidateUpdate($request, $id);

        if($dataIn=='Prediction')
        {
            $prediction->where('id', $id)->update($data);
        }
        else{
            $archive->where('id', $id)->update($data);
        }
        ResponseFacade::validationMessage('PREDICTION UPDATED SUCCESSFULLY', '0');
    }



    public function postVIPGameUpdate(Request $request, $id, $dataIn, Prediction $prediction, Archive $archive)
    {
        $data = $request->except('_token');

        $prediction->validateInput($request);
        $prediction->checkValidateUpdate($request, $id);

        if($dataIn=='Prediction')
        {
            $prediction->where('id', $id)->update($data);
        }
        else{
            $archive->where('id', $id)->update($data);
        }
        ResponseFacade::validationMessage('VIP PREDICTION UPDATED SUCCESSFULLY', '0');
    }




    public function archiveGame(Request $request, $id, Archive $archive)
    {
        return $archive->archiveGames($request, $id);
    }

    public function unarchiveGame($id, Prediction $prediction)
    {
        return $prediction->unarchiveGames($id);
    }




    public function ajaxAddResult($id, Prediction $prediction)
    {
        $game = $prediction->getPrediction($id);
        return view('ajaxfiles.addresult', ['game' => $game]);
    }

    public function postAddResult(Request $request, Prediction $prediction)
    {
        $prediction->addResult($request->all());
        ResponseFacade::validationMessage('OPERATION SUCCESSFUL', '0');
    }




    public function ajaxTestimonial(Request $request, Prediction $prediction)
    {
        $id = trim($request['id']);
        $value = trim($request['potential']);

        $prediction->find($id)
            ->update(['testimonial' => '1', 'testimonialValue' => $value]);

        ResponseFacade::validationMessage('GAME MARKED SUCCESSFULLY', '0');
    }



    public function ajaxGameDelete($id, $finder)
    {
        if($finder=='Prediction')
        {
            Prediction::destroy($id);
        }
        else{
            Archive::destroy($id);
        }
        echo 'Ok';
    }
}
